/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.kickstart.execution.context.ContextSetting;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="graphql.servlet")
public class GraphQLServletProperties {
    public static final Duration DEFAULT_SUBSCRIPTION_TIMEOUT = Duration.ZERO;
    private boolean enabled = true;
    private boolean corsEnabled = true;
    private String mapping = "/graphql";
    private boolean exceptionHandlersEnabled = false;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration subscriptionTimeout = DEFAULT_SUBSCRIPTION_TIMEOUT;
    private ContextSetting contextSetting = ContextSetting.PER_QUERY_WITH_INSTRUMENTATION;
    @Deprecated
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration asyncTimeout;
    @Deprecated
    private Boolean asyncModeEnabled;
    private String tracingEnabled = "false";
    private boolean actuatorMetrics;
    private Integer maxQueryComplexity;
    private Integer maxQueryDepth;

    public String getServletMapping() {
        String originalMapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return originalMapping.replaceAll("\\*$", "");
        }
        if (this.mappingIsServletWildcard()) {
            return originalMapping;
        }
        return originalMapping.endsWith("/") ? originalMapping + "*" : originalMapping + "/*";
    }

    public String getCorsMapping() {
        String originalMapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return originalMapping;
        }
        if (this.mappingIsServletWildcard()) {
            return originalMapping + "*";
        }
        return originalMapping.endsWith("/") ? originalMapping + "**" : originalMapping + "/**";
    }

    private boolean mappingIsServletWildcard() {
        return this.getMapping().endsWith("/*");
    }

    private boolean mappingIsAntWildcard() {
        return this.getMapping().endsWith("/**");
    }

    @Generated
    public GraphQLServletProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isCorsEnabled() {
        return this.corsEnabled;
    }

    @Generated
    public String getMapping() {
        return this.mapping;
    }

    @Generated
    public boolean isExceptionHandlersEnabled() {
        return this.exceptionHandlersEnabled;
    }

    @Generated
    public Duration getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    @Generated
    public ContextSetting getContextSetting() {
        return this.contextSetting;
    }

    @Deprecated
    @Generated
    public Duration getAsyncTimeout() {
        return this.asyncTimeout;
    }

    @Deprecated
    @Generated
    public Boolean getAsyncModeEnabled() {
        return this.asyncModeEnabled;
    }

    @Generated
    public String getTracingEnabled() {
        return this.tracingEnabled;
    }

    @Generated
    public boolean isActuatorMetrics() {
        return this.actuatorMetrics;
    }

    @Generated
    public Integer getMaxQueryComplexity() {
        return this.maxQueryComplexity;
    }

    @Generated
    public Integer getMaxQueryDepth() {
        return this.maxQueryDepth;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setCorsEnabled(boolean corsEnabled) {
        this.corsEnabled = corsEnabled;
    }

    @Generated
    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    @Generated
    public void setExceptionHandlersEnabled(boolean exceptionHandlersEnabled) {
        this.exceptionHandlersEnabled = exceptionHandlersEnabled;
    }

    @Generated
    public void setSubscriptionTimeout(Duration subscriptionTimeout) {
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Generated
    public void setContextSetting(ContextSetting contextSetting) {
        this.contextSetting = contextSetting;
    }

    @Deprecated
    @Generated
    public void setAsyncTimeout(Duration asyncTimeout) {
        this.asyncTimeout = asyncTimeout;
    }

    @Deprecated
    @Generated
    public void setAsyncModeEnabled(Boolean asyncModeEnabled) {
        this.asyncModeEnabled = asyncModeEnabled;
    }

    @Generated
    public void setTracingEnabled(String tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    @Generated
    public void setActuatorMetrics(boolean actuatorMetrics) {
        this.actuatorMetrics = actuatorMetrics;
    }

    @Generated
    public void setMaxQueryComplexity(Integer maxQueryComplexity) {
        this.maxQueryComplexity = maxQueryComplexity;
    }

    @Generated
    public void setMaxQueryDepth(Integer maxQueryDepth) {
        this.maxQueryDepth = maxQueryDepth;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQLServletProperties)) {
            return false;
        }
        GraphQLServletProperties other = (GraphQLServletProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isCorsEnabled() != other.isCorsEnabled()) {
            return false;
        }
        if (this.isExceptionHandlersEnabled() != other.isExceptionHandlersEnabled()) {
            return false;
        }
        if (this.isActuatorMetrics() != other.isActuatorMetrics()) {
            return false;
        }
        Boolean this$asyncModeEnabled = this.getAsyncModeEnabled();
        Boolean other$asyncModeEnabled = other.getAsyncModeEnabled();
        if (this$asyncModeEnabled == null ? other$asyncModeEnabled != null : !((Object)this$asyncModeEnabled).equals(other$asyncModeEnabled)) {
            return false;
        }
        Integer this$maxQueryComplexity = this.getMaxQueryComplexity();
        Integer other$maxQueryComplexity = other.getMaxQueryComplexity();
        if (this$maxQueryComplexity == null ? other$maxQueryComplexity != null : !((Object)this$maxQueryComplexity).equals(other$maxQueryComplexity)) {
            return false;
        }
        Integer this$maxQueryDepth = this.getMaxQueryDepth();
        Integer other$maxQueryDepth = other.getMaxQueryDepth();
        if (this$maxQueryDepth == null ? other$maxQueryDepth != null : !((Object)this$maxQueryDepth).equals(other$maxQueryDepth)) {
            return false;
        }
        String this$mapping = this.getMapping();
        String other$mapping = other.getMapping();
        if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
            return false;
        }
        Duration this$subscriptionTimeout = this.getSubscriptionTimeout();
        Duration other$subscriptionTimeout = other.getSubscriptionTimeout();
        if (this$subscriptionTimeout == null ? other$subscriptionTimeout != null : !((Object)this$subscriptionTimeout).equals(other$subscriptionTimeout)) {
            return false;
        }
        ContextSetting this$contextSetting = this.getContextSetting();
        ContextSetting other$contextSetting = other.getContextSetting();
        if (this$contextSetting == null ? other$contextSetting != null : !this$contextSetting.equals(other$contextSetting)) {
            return false;
        }
        Duration this$asyncTimeout = this.getAsyncTimeout();
        Duration other$asyncTimeout = other.getAsyncTimeout();
        if (this$asyncTimeout == null ? other$asyncTimeout != null : !((Object)this$asyncTimeout).equals(other$asyncTimeout)) {
            return false;
        }
        String this$tracingEnabled = this.getTracingEnabled();
        String other$tracingEnabled = other.getTracingEnabled();
        return !(this$tracingEnabled == null ? other$tracingEnabled != null : !this$tracingEnabled.equals(other$tracingEnabled));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphQLServletProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isCorsEnabled() ? 79 : 97);
        result = result * 59 + (this.isExceptionHandlersEnabled() ? 79 : 97);
        result = result * 59 + (this.isActuatorMetrics() ? 79 : 97);
        Boolean $asyncModeEnabled = this.getAsyncModeEnabled();
        result = result * 59 + ($asyncModeEnabled == null ? 43 : ((Object)$asyncModeEnabled).hashCode());
        Integer $maxQueryComplexity = this.getMaxQueryComplexity();
        result = result * 59 + ($maxQueryComplexity == null ? 43 : ((Object)$maxQueryComplexity).hashCode());
        Integer $maxQueryDepth = this.getMaxQueryDepth();
        result = result * 59 + ($maxQueryDepth == null ? 43 : ((Object)$maxQueryDepth).hashCode());
        String $mapping = this.getMapping();
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        Duration $subscriptionTimeout = this.getSubscriptionTimeout();
        result = result * 59 + ($subscriptionTimeout == null ? 43 : ((Object)$subscriptionTimeout).hashCode());
        ContextSetting $contextSetting = this.getContextSetting();
        result = result * 59 + ($contextSetting == null ? 43 : $contextSetting.hashCode());
        Duration $asyncTimeout = this.getAsyncTimeout();
        result = result * 59 + ($asyncTimeout == null ? 43 : ((Object)$asyncTimeout).hashCode());
        String $tracingEnabled = this.getTracingEnabled();
        result = result * 59 + ($tracingEnabled == null ? 43 : $tracingEnabled.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GraphQLServletProperties(enabled=" + this.isEnabled() + ", corsEnabled=" + this.isCorsEnabled() + ", mapping=" + this.getMapping() + ", exceptionHandlersEnabled=" + this.isExceptionHandlersEnabled() + ", subscriptionTimeout=" + this.getSubscriptionTimeout() + ", contextSetting=" + this.getContextSetting() + ", asyncTimeout=" + this.getAsyncTimeout() + ", asyncModeEnabled=" + this.getAsyncModeEnabled() + ", tracingEnabled=" + this.getTracingEnabled() + ", actuatorMetrics=" + this.isActuatorMetrics() + ", maxQueryComplexity=" + this.getMaxQueryComplexity() + ", maxQueryDepth=" + this.getMaxQueryDepth() + ")";
    }
}

