/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor.voyager;

import graphql.kickstart.autoconfigure.editor.voyager.ReactiveVoyagerController;
import graphql.kickstart.autoconfigure.editor.voyager.VoyagerIndexHtmlTemplate;
import graphql.kickstart.autoconfigure.editor.voyager.VoyagerPropertiesConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(value={"graphql.voyager.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={VoyagerPropertiesConfiguration.class})
public class ReactiveVoyagerAutoConfiguration {
    @Bean
    ReactiveVoyagerController voyagerController(VoyagerIndexHtmlTemplate voyagerIndexHtmlTemplate) {
        return new ReactiveVoyagerController(voyagerIndexHtmlTemplate);
    }

    @Bean
    public RouterFunction<ServerResponse> voyagerStaticFilesRouter() {
        return RouterFunctions.resources((String)"/vendor/voyager/**", (Resource)new ClassPathResource("static/vendor/voyager/"));
    }

    @Bean
    VoyagerIndexHtmlTemplate voyagerIndexHtmlTemplate(VoyagerPropertiesConfiguration voyagerPropertiesConfiguration) {
        return new VoyagerIndexHtmlTemplate(voyagerPropertiesConfiguration);
    }
}

