/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.tools;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import graphql.kickstart.autoconfigure.tools.ClasspathResourceSchemaStringProvider;
import graphql.kickstart.autoconfigure.tools.GraphQLToolsProperties;
import graphql.kickstart.autoconfigure.tools.SchemaDirective;
import graphql.kickstart.autoconfigure.tools.SchemaStringProvider;
import graphql.kickstart.execution.config.GraphQLSchemaProvider;
import graphql.kickstart.tools.CoroutineContextProvider;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.ObjectMapperConfigurer;
import graphql.kickstart.tools.PerFieldObjectMapperProvider;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserDictionary;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TypeDefinitionFactory;
import graphql.kickstart.tools.proxy.ProxyHandler;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SchemaParser.class})
@ConditionalOnProperty(value={"graphql.schema-strategy"}, havingValue="TOOLS", matchIfMissing=true)
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLToolsProperties.class})
public class GraphQLJavaToolsAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLJavaToolsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public SchemaStringProvider schemaStringProvider(ApplicationContext applicationContext, GraphQLToolsProperties props) {
        return new ClasspathResourceSchemaStringProvider(applicationContext, props.getSchemaLocationPattern());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(value="graphql.tools.schema-parser-options")
    public SchemaParserOptions.Builder optionsBuilder(@Autowired(required=false) PerFieldObjectMapperProvider perFieldObjectMapperProvider, @Autowired(required=false) List<SchemaParserOptions.GenericWrapper> genericWrappers, @Autowired(required=false) ObjectMapperConfigurer objectMapperConfigurer, @Autowired(required=false) List<ProxyHandler> proxyHandlers, @Autowired(required=false) CoroutineContextProvider coroutineContextProvider, @Autowired(required=false) List<TypeDefinitionFactory> typeDefinitionFactories, @Autowired(required=false) GraphqlFieldVisibility fieldVisibility) {
        SchemaParserOptions.Builder optionsBuilder = SchemaParserOptions.newOptions();
        if (perFieldObjectMapperProvider != null) {
            optionsBuilder.objectMapperProvider(perFieldObjectMapperProvider);
        } else {
            optionsBuilder.objectMapperConfigurer(objectMapperConfigurer);
        }
        Optional.ofNullable(genericWrappers).ifPresent(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).genericWrappers(arg_0));
        if (proxyHandlers != null) {
            proxyHandlers.forEach(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).addProxyHandler(arg_0));
        }
        Optional.ofNullable(coroutineContextProvider).ifPresent(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).coroutineContextProvider(arg_0));
        if (typeDefinitionFactories != null) {
            typeDefinitionFactories.forEach(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).typeDefinitionFactory(arg_0));
        }
        Optional.ofNullable(fieldVisibility).ifPresent(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).fieldVisibility(arg_0));
        return optionsBuilder;
    }

    @Bean
    @ConditionalOnBean(value={GraphQLResolver.class})
    @ConditionalOnMissingBean
    public SchemaParser schemaParser(List<GraphQLResolver<?>> resolvers, SchemaStringProvider schemaStringProvider, SchemaParserOptions.Builder optionsBuilder, @Autowired(required=false) SchemaParserDictionary dictionary, @Autowired(required=false) GraphQLScalarType[] scalars, @Autowired(required=false) List<SchemaDirective> directives, @Autowired(required=false) List<SchemaDirectiveWiring> directiveWirings) throws IOException {
        SchemaParserBuilder builder = new SchemaParserBuilder();
        if (Objects.nonNull(dictionary)) {
            builder.dictionary((Map)dictionary.getDictionary());
        }
        List<String> schemaStrings = schemaStringProvider.schemaStrings();
        schemaStrings.forEach(arg_0 -> ((SchemaParserBuilder)builder).schemaString(arg_0));
        if (scalars != null) {
            builder.scalars(scalars);
        }
        builder.options(optionsBuilder.build());
        if (directives != null) {
            directives.forEach(it -> builder.directive(it.getName(), it.getDirective()));
        }
        if (directiveWirings != null) {
            directiveWirings.forEach(arg_0 -> ((SchemaParserBuilder)builder).directiveWiring(arg_0));
        }
        return builder.resolvers(resolvers).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"graphql.tools.use-default-objectmapper"}, havingValue="true", matchIfMissing=true)
    public PerFieldObjectMapperProvider perFieldObjectMapperProvider(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new Jdk8Module()).registerModule((Module)new KotlinModule());
        return fieldDefinition -> objectMapper;
    }

    @Bean
    @ConditionalOnBean(value={SchemaParser.class})
    @ConditionalOnMissingBean(value={GraphQLSchema.class, GraphQLSchemaProvider.class})
    public GraphQLSchema graphQLSchema(SchemaParser schemaParser) {
        return schemaParser.makeExecutableSchema();
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.tools.introspection-enabled"}, havingValue="false")
    GraphqlFieldVisibility disableIntrospection() {
        log.warn("GraphQL introspection query disabled! This puts your server in contravention of the GraphQL specification and expectations of most clients, so use this option with caution");
        return new NoIntrospectionGraphqlFieldVisibility();
    }
}

