/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.kickstart.autoconfigure.web.OnSchemaOrSchemaProviderBean;
import graphql.kickstart.autoconfigure.web.servlet.AsyncServletProperties;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLServletProperties;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLWebAutoConfiguration;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.task.DelegatingSecurityContextAsyncTaskExecutor;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={OnSchemaOrSchemaProviderBean.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={GraphQLWebAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherServlet.class, DefaultAuthenticationEventPublisher.class})
@EnableConfigurationProperties(value={GraphQLServletProperties.class, AsyncServletProperties.class})
public class GraphQLWebSecurityAutoConfiguration {
    private final GraphQLServletProperties graphqlServletProperties;
    private final AsyncServletProperties asyncServletProperties;

    @Bean(value={"graphqlAsyncTaskExecutor"})
    @ConditionalOnMissingBean(name={"graphqlAsyncTaskExecutor"})
    public Executor threadPoolTaskExecutor() {
        if (this.isAsyncModeEnabled() && this.asyncServletProperties.isDelegateSecurityContext()) {
            ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
            executor.setCorePoolSize(this.asyncServletProperties.getThreads().getMin());
            executor.setMaxPoolSize(this.asyncServletProperties.getThreads().getMax());
            executor.setThreadNamePrefix(this.asyncServletProperties.getThreads().getNamePrefix());
            executor.initialize();
            return new DelegatingSecurityContextAsyncTaskExecutor((AsyncTaskExecutor)executor);
        }
        return null;
    }

    private boolean isAsyncModeEnabled() {
        return this.graphqlServletProperties.getAsyncModeEnabled() != null ? this.graphqlServletProperties.getAsyncModeEnabled().booleanValue() : this.asyncServletProperties.isEnabled();
    }

    @Generated
    public GraphQLWebSecurityAutoConfiguration(GraphQLServletProperties graphqlServletProperties, AsyncServletProperties asyncServletProperties) {
        this.graphqlServletProperties = graphqlServletProperties;
        this.asyncServletProperties = asyncServletProperties;
    }
}

