/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.kickstart.autoconfigure.tools.GraphQLJavaToolsAutoConfiguration;
import graphql.kickstart.autoconfigure.web.OnSchemaOrSchemaProviderBean;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLSubscriptionApolloProperties;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLSubscriptionWebsocketProperties;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLWebAutoConfiguration;
import graphql.kickstart.autoconfigure.web.servlet.GraphQLWsServerEndpointRegistration;
import graphql.kickstart.autoconfigure.web.servlet.WsCsrfFilter;
import graphql.kickstart.autoconfigure.web.servlet.WsCsrfTokenRepository;
import graphql.kickstart.autoconfigure.web.servlet.WsSessionCsrfTokenRepository;
import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.SubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.KeepAliveSubscriptionConnectionListener;
import graphql.kickstart.servlet.GraphQLWebsocketServlet;
import jakarta.websocket.server.ServerContainer;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={DispatcherServlet.class, ServerEndpointRegistration.class})
@Conditional(value={OnSchemaOrSchemaProviderBean.class})
@ConditionalOnProperty(value={"graphql.servlet.websocket.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class, GraphQLWebAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLSubscriptionApolloProperties.class, GraphQLSubscriptionWebsocketProperties.class})
public class GraphQLWebsocketAutoConfiguration {
    private final GraphQLSubscriptionApolloProperties apolloProperties;
    private final GraphQLSubscriptionWebsocketProperties websocketProperties;

    @Bean
    @ConditionalOnMissingBean
    public GraphQLWebsocketServlet graphQLWebsocketServlet(GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, GraphQLObjectMapper graphQLObjectMapper, @Autowired(required=false) Collection<SubscriptionConnectionListener> connectionListeners) {
        HashSet<SubscriptionConnectionListener> listeners = new HashSet<SubscriptionConnectionListener>();
        if (connectionListeners != null) {
            listeners.addAll(connectionListeners);
        }
        this.keepAliveListener().ifPresent(listeners::add);
        return new GraphQLWebsocketServlet(graphQLInvoker, invocationInputFactory, graphQLObjectMapper, listeners);
    }

    private Optional<SubscriptionConnectionListener> keepAliveListener() {
        if (this.apolloProperties.isKeepAliveEnabled()) {
            return Optional.of(new KeepAliveSubscriptionConnectionListener(Duration.ofSeconds(this.apolloProperties.getKeepAliveIntervalSeconds())));
        }
        return Optional.empty();
    }

    @Bean
    public WsCsrfFilter wsCsrfFilter(@Autowired(required=false) WsCsrfTokenRepository csrfTokenRepository) {
        return new WsCsrfFilter(this.websocketProperties.getCsrf(), csrfTokenRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={HttpSessionCsrfTokenRepository.class})
    public WsCsrfTokenRepository wsCsrfTokenRepository() {
        return new WsSessionCsrfTokenRepository();
    }

    @Bean
    @ConditionalOnClass(value={ServerContainer.class})
    public ServerEndpointRegistration serverEndpointRegistration(GraphQLWebsocketServlet servlet, WsCsrfFilter csrfFilter) {
        return new GraphQLWsServerEndpointRegistration(this.websocketProperties.getPath(), servlet, csrfFilter, this.websocketProperties.getAllowedOrigins());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={ServerContainer.class})
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    @Generated
    public GraphQLWebsocketAutoConfiguration(GraphQLSubscriptionApolloProperties apolloProperties, GraphQLSubscriptionWebsocketProperties websocketProperties) {
        this.apolloProperties = apolloProperties;
        this.websocketProperties = websocketProperties;
    }
}

