/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.kickstart.autoconfigure.web.servlet.WsCsrfFilter;
import graphql.kickstart.servlet.GraphQLWebsocketServlet;
import jakarta.websocket.Endpoint;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.Lifecycle;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class GraphQLWsServerEndpointRegistration
extends ServerEndpointRegistration
implements Lifecycle {
    private static final String ALL = "*";
    private final GraphQLWebsocketServlet servlet;
    private final WsCsrfFilter csrfFilter;
    private final List<String> allowedOrigins;

    public GraphQLWsServerEndpointRegistration(String path, GraphQLWebsocketServlet servlet, WsCsrfFilter csrfFilter, List<String> allowedOrigins) {
        super(path, (Endpoint)servlet);
        this.servlet = servlet;
        this.allowedOrigins = allowedOrigins == null || allowedOrigins.isEmpty() ? List.of(ALL) : new ArrayList<String>(allowedOrigins);
        this.csrfFilter = csrfFilter;
    }

    public boolean checkOrigin(String originHeaderValue) {
        if (originHeaderValue == null || originHeaderValue.isBlank()) {
            return this.allowedOrigins.contains(ALL);
        }
        if (this.allowedOrigins.contains(ALL)) {
            return true;
        }
        String originToCheck = this.trimTrailingSlash(originHeaderValue);
        return this.allowedOrigins.stream().map(this::trimTrailingSlash).anyMatch(originToCheck::equalsIgnoreCase);
    }

    private String trimTrailingSlash(String origin) {
        return origin.endsWith("/") ? origin.substring(0, origin.length() - 1) : origin;
    }

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        super.modifyHandshake(sec, request, response);
        this.csrfFilter.doFilter(request);
        this.servlet.modifyHandshake(sec, request, response);
    }

    public void start() {
    }

    public void stop() {
        this.servlet.beginShutDown();
    }

    public boolean isRunning() {
        return !this.servlet.isShutDown();
    }
}

