/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet;

import graphql.kickstart.autoconfigure.web.servlet.GraphQLSubscriptionWebsocketProperties;
import graphql.kickstart.autoconfigure.web.servlet.WsCsrfToken;
import graphql.kickstart.autoconfigure.web.servlet.WsCsrfTokenRepository;
import jakarta.websocket.server.HandshakeRequest;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

class WsCsrfFilter {
    private final GraphQLSubscriptionWebsocketProperties.CsrfProperties csrfProperties;
    private final WsCsrfTokenRepository tokenRepository;

    void doFilter(HandshakeRequest request) {
        if (this.csrfProperties.isEnabled() && this.tokenRepository != null) {
            boolean missingToken;
            WsCsrfToken csrfToken = this.tokenRepository.loadToken(request);
            boolean bl = missingToken = csrfToken == null;
            if (missingToken) {
                csrfToken = this.tokenRepository.generateToken(request);
                this.tokenRepository.saveToken(csrfToken, request);
            }
            String actualToken = (String)CollectionUtils.firstElement((List)((List)request.getParameterMap().get(csrfToken.getParameterName())));
            if (!Objects.equals(csrfToken.getToken(), actualToken)) {
                throw new IllegalStateException("Invalid CSRF Token '" + actualToken + "' was found on the request parameter '" + csrfToken.getParameterName() + "'.");
            }
        }
    }

    @Generated
    public WsCsrfFilter(GraphQLSubscriptionWebsocketProperties.CsrfProperties csrfProperties, WsCsrfTokenRepository tokenRepository) {
        this.csrfProperties = csrfProperties;
        this.tokenRepository = tokenRepository;
    }
}

