/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.web.servlet.metrics;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class MetricsInstrumentation
extends TracingInstrumentation {
    private static final String QUERY_TIME_METRIC_NAME = "graphql.timer.query";
    private static final String RESOLVER_TIME_METRIC_NAME = "graphql.timer.resolver";
    private static final String OPERATION_NAME_TAG = "operationName";
    private static final String OPERATION = "operation";
    private static final String UNKNOWN_OPERATION_NAME = "unknown";
    private static final String PARENT = "parent";
    private static final String FIELD = "field";
    private static final String TRACING = "tracing";
    private static final String DURATION = "duration";
    private static final String EXECUTION = "execution";
    private static final String VALIDATION = "validation";
    private static final String PARSING = "parsing";
    private static final String RESOLVERS = "resolvers";
    private static final String TIMER_DESCRIPTION = "Timer that records the time to fetch the data by Operation Name";
    private final MeterRegistry meterRegistry;
    private final boolean tracingEnabled;

    public MetricsInstrumentation(MeterRegistry meterRegistry, boolean tracingEnabled) {
        this.meterRegistry = meterRegistry;
        this.tracingEnabled = tracingEnabled;
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        return this.instrumentExecutionResult(executionResult, parameters, null);
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters, InstrumentationState rawState) {
        if (executionResult.getExtensions() != null && executionResult.getExtensions().containsKey(TRACING)) {
            Map tracingData = (Map)executionResult.getExtensions().get(TRACING);
            Timer executionTimer = this.buildQueryTimer(parameters.getOperation(), EXECUTION);
            executionTimer.record(((Long)tracingData.get(DURATION)).longValue(), TimeUnit.NANOSECONDS);
            if (tracingData.containsKey(VALIDATION) && ((Map)tracingData.get(VALIDATION)).containsKey(DURATION)) {
                Timer validationTimer = this.buildQueryTimer(parameters.getOperation(), VALIDATION);
                validationTimer.record(((Long)((Map)tracingData.get(VALIDATION)).get(DURATION)).longValue(), TimeUnit.NANOSECONDS);
            }
            if (tracingData.containsKey(PARSING) && ((Map)tracingData.get(PARSING)).containsKey(DURATION)) {
                Timer parsingTimer = this.buildQueryTimer(parameters.getOperation(), PARSING);
                parsingTimer.record(((Long)((Map)tracingData.get(PARSING)).get(DURATION)).longValue(), TimeUnit.NANOSECONDS);
            }
            if (((Map)tracingData.get(EXECUTION)).containsKey(RESOLVERS)) {
                ((List)((Map)tracingData.get(EXECUTION)).get(RESOLVERS)).forEach(field -> {
                    Timer fieldTimer = this.buildFieldTimer(parameters.getOperation(), RESOLVERS, (String)field.get("parentType"), (String)field.get("fieldName"));
                    fieldTimer.record(((Long)field.get(DURATION)).longValue(), TimeUnit.NANOSECONDS);
                });
            }
            if (!this.tracingEnabled) {
                executionResult.getExtensions().remove(TRACING);
            }
        }
        return CompletableFuture.completedFuture(executionResult);
    }

    private Timer buildQueryTimer(String operationName, String operation) {
        return Timer.builder((String)QUERY_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName != null ? operationName : UNKNOWN_OPERATION_NAME).tag(OPERATION, operation).register(this.meterRegistry);
    }

    private Timer buildFieldTimer(String operationName, String operation, String parent, String field) {
        return Timer.builder((String)RESOLVER_TIME_METRIC_NAME).description(TIMER_DESCRIPTION).tag(OPERATION_NAME_TAG, operationName != null ? operationName : UNKNOWN_OPERATION_NAME).tag(PARENT, parent).tag(FIELD, field).tag(OPERATION, operation).register(this.meterRegistry);
    }
}

