/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.SchemaStringProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ClasspathResourceSchemaStringProvider
implements SchemaStringProvider {
    @Autowired
    private ApplicationContext applicationContext;
    private String schemaLocationPattern;

    public ClasspathResourceSchemaStringProvider(String schemaLocationPattern) {
        this.schemaLocationPattern = schemaLocationPattern;
    }

    @Override
    public List<String> schemaStrings() throws IOException {
        Resource[] resources = this.applicationContext.getResources("classpath*:" + this.schemaLocationPattern);
        if (resources.length <= 0) {
            throw new IllegalStateException("No graphql schema files found on classpath with location pattern '" + this.schemaLocationPattern + "'.  Please add a graphql schema to the classpath or add a SchemaParser bean to your application context.");
        }
        return Arrays.stream(resources).map(this::readSchema).collect(Collectors.toList());
    }

    private String readSchema(Resource resource) {
        StringWriter writer = new StringWriter();
        try (InputStream inputStream = resource.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read graphql schema from resource " + resource, e);
        }
        return writer.toString();
    }
}

