/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.PerFieldObjectMapperProvider;
import com.coxautodev.graphql.tools.SchemaParser;
import com.coxautodev.graphql.tools.SchemaParserBuilder;
import com.coxautodev.graphql.tools.SchemaParserDictionary;
import com.coxautodev.graphql.tools.SchemaParserOptions;
import com.coxautodev.graphql.tools.TypeDefinitionFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.oembedler.moon.graphql.boot.ClasspathResourceSchemaStringProvider;
import com.oembedler.moon.graphql.boot.GraphQLToolsProperties;
import com.oembedler.moon.graphql.boot.SchemaDirective;
import com.oembedler.moon.graphql.boot.SchemaStringProvider;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.config.GraphQLSchemaProvider;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SchemaParser.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLToolsProperties.class})
public class GraphQLJavaToolsAutoConfiguration {
    @Autowired(required=false)
    private SchemaParserDictionary dictionary;
    @Autowired(required=false)
    private GraphQLScalarType[] scalars;
    @Autowired(required=false)
    private SchemaParserOptions options;
    @Autowired(required=false)
    private List<SchemaDirective> directives;
    @Autowired(required=false)
    private List<TypeDefinitionFactory> typeDefinitionFactories;
    @Autowired
    private GraphQLToolsProperties props;

    @Bean
    @ConditionalOnMissingBean
    public SchemaStringProvider schemaStringProvider() {
        return new ClasspathResourceSchemaStringProvider(this.props.getSchemaLocationPattern());
    }

    @Bean
    @ConditionalOnBean(value={GraphQLResolver.class})
    @ConditionalOnMissingBean
    public SchemaParser schemaParser(List<GraphQLResolver<?>> resolvers, SchemaStringProvider schemaStringProvider, PerFieldObjectMapperProvider perFieldObjectMapperProvider) throws IOException {
        SchemaParserBuilder builder = this.dictionary != null ? new SchemaParserBuilder(this.dictionary) : new SchemaParserBuilder();
        List<String> schemaStrings = schemaStringProvider.schemaStrings();
        schemaStrings.forEach(arg_0 -> ((SchemaParserBuilder)builder).schemaString(arg_0));
        if (this.scalars != null) {
            builder.scalars(this.scalars);
        }
        if (this.options != null) {
            builder.options(this.options);
        } else {
            SchemaParserOptions.Builder optionsBuilder = SchemaParserOptions.newOptions();
            if (perFieldObjectMapperProvider != null) {
                optionsBuilder.objectMapperProvider(perFieldObjectMapperProvider);
            }
            optionsBuilder.introspectionEnabled(this.props.isIntrospectionEnabled());
            if (this.typeDefinitionFactories != null) {
                this.typeDefinitionFactories.forEach(arg_0 -> ((SchemaParserOptions.Builder)optionsBuilder).typeDefinitionFactory(arg_0));
            }
            builder.options(optionsBuilder.build());
        }
        if (this.directives != null) {
            this.directives.forEach(it -> builder.directive(it.getName(), it.getDirective()));
        }
        return builder.resolvers(resolvers).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"graphql.tools.use-default-objectmapper"}, havingValue="true", matchIfMissing=true)
    public PerFieldObjectMapperProvider perFieldObjectMapperProvider(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new Jdk8Module()).registerModule((Module)new KotlinModule());
        return fieldDefinition -> objectMapper;
    }

    @Bean
    @ConditionalOnBean(value={SchemaParser.class})
    @ConditionalOnMissingBean(value={GraphQLSchema.class, GraphQLSchemaProvider.class})
    public GraphQLSchema graphQLSchema(SchemaParser schemaParser) {
        return schemaParser.makeExecutableSchema();
    }
}

