/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.GraphQLJavaToolsAutoConfiguration;
import com.oembedler.moon.graphql.boot.GraphQLSubscriptionApolloProperties;
import com.oembedler.moon.graphql.boot.GraphQLWsServerEndpointRegistration;
import com.oembedler.moon.graphql.boot.OnSchemaOrSchemaProviderBean;
import graphql.servlet.GraphQLWebsocketServlet;
import graphql.servlet.core.ApolloSubscriptionConnectionListener;
import graphql.servlet.core.GraphQLObjectMapper;
import graphql.servlet.core.GraphQLQueryInvoker;
import graphql.servlet.core.SubscriptionConnectionListener;
import graphql.servlet.input.GraphQLInvocationInputFactory;
import java.time.Duration;
import javax.websocket.server.ServerContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@Conditional(value={OnSchemaOrSchemaProviderBean.class})
@ConditionalOnProperty(value={"graphql.servlet.websocket.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLSubscriptionApolloProperties.class})
public class GraphQLWebsocketAutoConfiguration {
    @Value(value="${graphql.servlet.subscriptions.websocket.path:/subscriptions}")
    private String websocketPath;
    @Autowired
    private GraphQLSubscriptionApolloProperties apolloProperties;

    @Bean
    @ConditionalOnMissingBean
    public SubscriptionConnectionListener subscriptionConnectionListener() {
        if (!this.apolloProperties.isKeepAliveEnabled()) {
            return ApolloSubscriptionConnectionListener.createWithKeepAliveDisabled();
        }
        return ApolloSubscriptionConnectionListener.createWithKeepAliveInterval((Duration)Duration.ofSeconds(this.apolloProperties.getKeepAliveIntervalSeconds()));
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLWebsocketServlet graphQLWebsocketServlet(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper, SubscriptionConnectionListener subscriptionConnectionListener) {
        return new GraphQLWebsocketServlet(queryInvoker, invocationInputFactory, graphQLObjectMapper, subscriptionConnectionListener);
    }

    @Bean
    @ConditionalOnClass(value={ServerContainer.class})
    public ServerEndpointRegistration serverEndpointRegistration(GraphQLWebsocketServlet servlet) {
        return new GraphQLWsServerEndpointRegistration(this.websocketPath, servlet);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={ServerContainer.class})
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }
}

