/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot.error;

import com.oembedler.moon.graphql.boot.error.GraphQLErrorFactory;
import com.oembedler.moon.graphql.boot.error.ThrowableComparator;
import com.oembedler.moon.graphql.boot.error.ThrowableGraphQLError;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphQLException;
import graphql.SerializationError;
import graphql.servlet.core.DefaultGraphQLErrorHandler;
import graphql.servlet.core.GenericGraphQLError;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQLErrorFromExceptionHandler
extends DefaultGraphQLErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQLErrorFromExceptionHandler.class);
    private List<GraphQLErrorFactory> factories;

    GraphQLErrorFromExceptionHandler(List<GraphQLErrorFactory> factories) {
        this.factories = factories;
    }

    protected List<GraphQLError> filterGraphQLErrors(List<GraphQLError> errors) {
        return errors.stream().map(this::transform).collect(Collectors.toList());
    }

    private GraphQLError transform(GraphQLError error) {
        return this.extractException(error).map(this::transform).orElse(this.defaultError(error.getMessage()));
    }

    private Optional<Throwable> extractException(GraphQLError error) {
        if (error instanceof ExceptionWhileDataFetching) {
            return Optional.of(((ExceptionWhileDataFetching)error).getException());
        }
        if (error instanceof SerializationError) {
            return Optional.of(((SerializationError)error).getException());
        }
        if (error instanceof GraphQLException) {
            return Optional.of((GraphQLException)error);
        }
        return Optional.empty();
    }

    private GraphQLError transform(Throwable throwable) {
        HashMap applicables = new HashMap();
        this.factories.forEach(factory -> factory.mostConcrete(throwable).ifPresent(t -> applicables.put(t, factory)));
        return applicables.keySet().stream().min(new ThrowableComparator()).map(applicables::get).map(factory -> factory.create(throwable)).orElse(this.defaultError(throwable));
    }

    private GraphQLError defaultError(Throwable throwable) {
        return new ThrowableGraphQLError(throwable);
    }

    private GraphQLError defaultError(String message) {
        return new GenericGraphQLError(message);
    }
}

