/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot.error;

import com.oembedler.moon.graphql.boot.error.ErrorHandlerSupplier;
import com.oembedler.moon.graphql.boot.error.GraphQLErrorHandlerFactory;
import graphql.servlet.core.GraphQLErrorHandler;
import javax.validation.constraints.NotNull;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

public class GraphQLErrorStartupListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final ErrorHandlerSupplier errorHandlerSupplier;
    private final boolean exceptionHandlersEnabled;

    public GraphQLErrorStartupListener(ErrorHandlerSupplier errorHandlerSupplier, boolean exceptionHandlersEnabled) {
        this.errorHandlerSupplier = errorHandlerSupplier;
        this.exceptionHandlersEnabled = exceptionHandlersEnabled;
    }

    public void onApplicationEvent(@NotNull ContextRefreshedEvent event) {
        if (!this.errorHandlerSupplier.isPresent()) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)event.getApplicationContext();
            GraphQLErrorHandler errorHandler = new GraphQLErrorHandlerFactory().create(context, this.exceptionHandlersEnabled);
            context.getBeanFactory().registerSingleton(errorHandler.getClass().getCanonicalName(), (Object)errorHandler);
            this.errorHandlerSupplier.setErrorHandler(errorHandler);
        }
    }
}

