/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.web.boot;

import graphql.kickstart.execution.context.ContextSetting;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="graphql.servlet")
public class GraphQLServletProperties {
    private String mapping;
    private boolean asyncModeEnabled = false;
    private boolean exceptionHandlersEnabled = false;
    private long subscriptionTimeout = 0L;
    private ContextSetting contextSetting = ContextSetting.PER_QUERY_WITH_INSTRUMENTATION;

    public String getMapping() {
        return this.mapping != null ? this.mapping : "/graphql";
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    private boolean mappingIsServletWildcard() {
        return this.getMapping().endsWith("/*");
    }

    private boolean mappingIsAntWildcard() {
        return this.getMapping().endsWith("/**");
    }

    public String getServletMapping() {
        String mapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return mapping.replaceAll("\\*$", "");
        }
        if (this.mappingIsServletWildcard()) {
            return mapping;
        }
        return mapping.endsWith("/") ? mapping + "*" : mapping + "/*";
    }

    public String getCorsMapping() {
        String mapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return mapping;
        }
        if (this.mappingIsServletWildcard()) {
            return mapping + "*";
        }
        return mapping.endsWith("/") ? mapping + "**" : mapping + "/**";
    }

    public boolean isAsyncModeEnabled() {
        return this.asyncModeEnabled;
    }

    public void setAsyncModeEnabled(boolean asyncModeEnabled) {
        this.asyncModeEnabled = asyncModeEnabled;
    }

    public boolean isExceptionHandlersEnabled() {
        return this.exceptionHandlersEnabled;
    }

    public void setExceptionHandlersEnabled(boolean exceptionHandlersEnabled) {
        this.exceptionHandlersEnabled = exceptionHandlersEnabled;
    }

    public long getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    public void setSubscriptionTimeout(long subscriptionTimeout) {
        this.subscriptionTimeout = subscriptionTimeout;
    }

    public ContextSetting getContextSetting() {
        return this.contextSetting;
    }

    public void setContextSetting(ContextSetting contextSetting) {
        this.contextSetting = contextSetting;
    }
}

