/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphql.spring.boot.test.GraphQLTestSubscription;
import com.graphql.spring.boot.test.GraphQLTestTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
public class GraphQLTestAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GraphQLTestTemplate graphQLTestUtils() {
        return new GraphQLTestTemplate();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLTestSubscription graphQLTestSubscription(Environment environment, ObjectMapper objectMapper, @Value(value="${graphql.servlet.subscriptions.websocket.path:subscriptions}") String subscriptionPath) {
        return new GraphQLTestSubscription(environment, objectMapper, subscriptionPath);
    }
}

