/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphql.spring.boot.test.GraphQLResponse;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import lombok.NonNull;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.ResourceUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

public class GraphQLTestSubscription {
    private static final Logger log = LoggerFactory.getLogger(GraphQLTestSubscription.class);
    private static final int SLEEP_INTERVAL_MS = 100;
    private static final int ACKNOWLEDGEMENT_AND_CONNECTION_TIMEOUT = 6000000;
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private static final UriBuilderFactory URI_BUILDER_FACTORY = new DefaultUriBuilderFactory();
    private Session session;
    private boolean initialized = false;
    private boolean acknowledged = false;
    private boolean started = false;
    private boolean stopped = false;
    private final Environment environment;
    private final ObjectMapper objectMapper;
    private final String subscriptionPath;
    private final Queue<GraphQLResponse> responses = new ConcurrentLinkedQueue<GraphQLResponse>();
    private int id = ID_COUNTER.getAndIncrement();

    public GraphQLTestSubscription init() {
        this.init(null);
        return this;
    }

    public GraphQLTestSubscription init(@Nullable Object payload) {
        if (this.initialized) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already initialized.");
        }
        try {
            this.initClient();
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Could not initialize test subscription client. No subscription defined?", (Throwable)e);
        }
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "connection_init");
        message.set("payload", this.getFinalPayload(payload));
        this.sendMessage(message);
        this.initialized = true;
        this.awaitAcknowledgement();
        return this;
    }

    public GraphQLTestSubscription start(@NonNull String graphQLResource) {
        if (graphQLResource == null) {
            throw new NullPointerException("graphQLResource is marked non-null but is null");
        }
        this.start(graphQLResource, null);
        return this;
    }

    public GraphQLTestSubscription start(@NonNull String graphGLResource, @Nullable Object variables) {
        if (graphGLResource == null) {
            throw new NullPointerException("graphGLResource is marked non-null but is null");
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            org.junit.jupiter.api.Assertions.fail((String)"Start message already sent. To start a new subscription, please call reset first.");
        }
        this.started = true;
        ObjectNode payload = this.objectMapper.createObjectNode();
        payload.put("query", this.loadQuery(graphGLResource));
        payload.set("variables", this.getFinalPayload(variables));
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "start");
        message.put("id", this.id);
        message.set("payload", (JsonNode)payload);
        this.sendMessage(message);
        return this;
    }

    public GraphQLTestSubscription stop() {
        if (!this.initialized) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription not yet initialized.");
        }
        if (this.stopped) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already stopped.");
        }
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "stop");
        message.put("id", this.id);
        this.sendMessage(message);
        this.stopped = true;
        try {
            this.session.close();
            this.session = null;
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Could not close web socket session", (Throwable)e);
        }
        log.debug("Subscription stopped.");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.initialized && !this.stopped) {
            this.stop();
        }
        if (this.stopped) {
            this.id = ID_COUNTER.getAndIncrement();
        }
        this.initialized = false;
        this.started = false;
        this.stopped = false;
        this.acknowledged = false;
        this.session = null;
        Queue<GraphQLResponse> queue = this.responses;
        synchronized (queue) {
            this.responses.clear();
        }
    }

    public GraphQLResponse awaitAndGetNextResponse(int timeout) {
        return this.awaitAndGetNextResponses(timeout, 1, true).get(0);
    }

    public GraphQLResponse awaitAndGetNextResponse(int timeout, boolean stopAfter) {
        return this.awaitAndGetNextResponses(timeout, 1, stopAfter).get(0);
    }

    public List<GraphQLResponse> awaitAndGetAllResponses(int timeToWait) {
        return this.awaitAndGetNextResponses(timeToWait, -1, true);
    }

    public List<GraphQLResponse> awaitAndGetAllResponses(int timeToWait, boolean stopAfter) {
        return this.awaitAndGetNextResponses(timeToWait, -1, stopAfter);
    }

    public List<GraphQLResponse> awaitAndGetNextResponses(int timeout, int numExpectedResponses) {
        return this.awaitAndGetNextResponses(timeout, numExpectedResponses, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphQLResponse> awaitAndGetNextResponses(int timeout, int numExpectedResponses, boolean stopAfter) {
        if (!this.started) {
            org.junit.jupiter.api.Assertions.fail((String)"Start message not sent. Please send start message first.");
        }
        if (this.stopped) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already stopped. Forgot to call reset after test case?");
        }
        int elapsedTime = 0;
        while ((this.responses.size() < numExpectedResponses || numExpectedResponses <= 0) && elapsedTime < timeout) {
            try {
                Thread.sleep(100L);
                elapsedTime += 100;
            }
            catch (InterruptedException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Test execution error - Thread.sleep failed.", (Throwable)e);
            }
        }
        Queue<GraphQLResponse> queue = this.responses;
        synchronized (queue) {
            if (stopAfter) {
                this.stop();
            }
            int responsesToPoll = this.responses.size();
            if (numExpectedResponses == 0) {
                ((IterableAssert)Assertions.assertThat(this.responses).as(String.format("Expected no responses in %s MS, but received %s", timeout, this.responses.size()), new Object[0])).isEmpty();
            }
            if (numExpectedResponses > 0) {
                ((IterableAssert)Assertions.assertThat(this.responses).as("Expected at least %s message(s) in %d MS, but %d received.", new Object[]{numExpectedResponses, timeout, this.responses.size()})).hasSizeGreaterThanOrEqualTo(numExpectedResponses);
                responsesToPoll = numExpectedResponses;
            }
            ArrayList<GraphQLResponse> responseList = new ArrayList<GraphQLResponse>();
            for (int i = 0; i < responsesToPoll; ++i) {
                responseList.add(this.responses.poll());
            }
            log.debug("Returning {} responses.", (Object)responseList.size());
            return responseList;
        }
    }

    public GraphQLTestSubscription waitAndExpectNoResponse(int timeToWait, boolean stopAfter) {
        this.awaitAndGetNextResponses(timeToWait, 0, stopAfter);
        return this;
    }

    public GraphQLTestSubscription waitAndExpectNoResponse(int timeToWait) {
        this.awaitAndGetNextResponses(timeToWait, 0, true);
        return this;
    }

    public List<GraphQLResponse> getRemainingResponses() {
        if (!this.stopped) {
            org.junit.jupiter.api.Assertions.fail((String)"getRemainingResponses should only be called after the subscription was stopped.");
        }
        ArrayList<GraphQLResponse> graphQLResponses = new ArrayList<GraphQLResponse>(this.responses);
        this.responses.clear();
        return graphQLResponses;
    }

    private void initClient() throws Exception {
        WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
        String port = this.environment.getProperty("local.server.port");
        URI uri = URI_BUILDER_FACTORY.builder().scheme("ws").host("localhost").port(port).path(this.subscriptionPath).build(new Object[0]);
        log.debug("Connecting to client at {}", (Object)uri);
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)new TestWebSocketClientConfigurator()).build();
        clientEndpointConfig.getUserProperties().put("org.apache.tomcat.websocket.IO_TIMEOUT_MS", String.valueOf(6000000));
        this.session = webSocketContainer.connectToServer(TestWebSocketClient.class, clientEndpointConfig, uri);
        this.session.addMessageHandler((MessageHandler)new TestMessageHandler());
    }

    private JsonNode getFinalPayload(Object variables) {
        return (JsonNode)Optional.ofNullable(variables).map(arg_0 -> ((ObjectMapper)this.objectMapper).valueToTree(arg_0)).orElseGet(() -> ((ObjectMapper)this.objectMapper).createObjectNode());
    }

    private String loadQuery(String graphGLResource) {
        try {
            File file = ResourceUtils.getFile((String)("classpath:" + graphGLResource));
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)String.format("Test setup failure - could not load GraphQL resource: %s", graphGLResource), (Throwable)e);
            return "";
        }
    }

    private void sendMessage(Object message) {
        try {
            this.session.getBasicRemote().sendText(this.objectMapper.writeValueAsString(message));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test setup failure - cannot serialize subscription payload.", (Throwable)e);
        }
    }

    private void awaitAcknowledgement() {
        int elapsedTime = 0;
        while (!this.acknowledged && elapsedTime < 6000000) {
            try {
                Thread.sleep(100L);
                elapsedTime += 100;
            }
            catch (InterruptedException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Test execution error - Thread.sleep failed.", (Throwable)e);
            }
        }
        if (!this.acknowledged) {
            org.junit.jupiter.api.Assertions.fail((String)"Timeout: Connection was not acknowledged by the GraphQL server.");
        }
    }

    public GraphQLTestSubscription(Environment environment, ObjectMapper objectMapper, String subscriptionPath) {
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.subscriptionPath = subscriptionPath;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    static class TestWebSocketClientConfigurator
    extends ClientEndpointConfig.Configurator {
        TestWebSocketClientConfigurator() {
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            super.beforeRequest(headers);
            headers.put("sec-websocket-protocol", Collections.singletonList("graphql-ws"));
        }
    }

    public static class TestWebSocketClient
    extends Endpoint {
        public void onOpen(Session session, EndpointConfig config) {
            log.debug("Connection established.");
        }
    }

    class TestMessageHandler
    implements MessageHandler.Whole<String> {
        TestMessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String message) {
            block6: {
                try {
                    log.debug("Received message from web socket: {}", (Object)message);
                    JsonNode jsonNode = GraphQLTestSubscription.this.objectMapper.readTree(message);
                    JsonNode typeNode = jsonNode.get("type");
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)typeNode.isNull()).as("GraphQL messages should have a type field.", new Object[0])).isFalse();
                    String type = typeNode.asText();
                    if (type.equals("connection_ack")) {
                        GraphQLTestSubscription.this.acknowledged = true;
                        log.debug("WebSocket connection acknowledged by the GraphQL Server.");
                        break block6;
                    }
                    if (!type.equals("data") && !type.equals("error")) break block6;
                    JsonNode payload = jsonNode.get("payload");
                    ((IterableAssert)Assertions.assertThat((Iterable)payload).as("Data/error messages must have a payload.", new Object[0])).isNotNull();
                    String payloadString = GraphQLTestSubscription.this.objectMapper.writeValueAsString((Object)payload);
                    GraphQLResponse graphQLResponse = new GraphQLResponse((ResponseEntity<String>)ResponseEntity.ok((Object)payloadString), GraphQLTestSubscription.this.objectMapper);
                    Queue queue = GraphQLTestSubscription.this.responses;
                    synchronized (queue) {
                        GraphQLTestSubscription.this.responses.add(graphQLResponse);
                    }
                }
                catch (JsonProcessingException e) {
                    org.junit.jupiter.api.Assertions.fail((String)"Exception while parsing server response. Response is not a valid GraphQL response.", (Throwable)e);
                }
            }
        }
    }
}

