/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test.assertions;

import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.GraphQLTestError;
import com.graphql.spring.boot.test.assertions.GraphQLResponseAssertion;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.AbstractIntegerAssert;

public class NumberOfErrorsAssertion
extends AbstractIntegerAssert<NumberOfErrorsAssertion>
implements GraphQLResponseAssertion {
    private final GraphQLResponse graphQLResponse;

    public NumberOfErrorsAssertion(GraphQLResponse response) {
        super(NumberOfErrorsAssertion.getNumberOfErrors(response), NumberOfErrorsAssertion.class);
        this.graphQLResponse = response;
    }

    private static Integer getNumberOfErrors(GraphQLResponse response) {
        int numErrors = 0;
        try {
            List<GraphQLTestError> errorList = response.getList("$.errors", GraphQLTestError.class);
            if (Objects.nonNull(errorList)) {
                numErrors = errorList.size();
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return numErrors;
    }

    @Override
    public GraphQLResponse and() {
        return this.graphQLResponse;
    }
}

