/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webclient.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.spring.webclient.boot.GraphQLClientProperties;
import graphql.kickstart.spring.webclient.boot.GraphQLWebClient;
import graphql.kickstart.spring.webclient.boot.GraphQLWebClientImpl;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@AutoConfigureAfter(value={JacksonAutoConfiguration.class, OAuth2ClientAutoConfiguration.class, WebFluxAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLClientProperties.class})
@ComponentScan(basePackageClasses={GraphQLWebClientImpl.class})
public class GraphQLWebClientAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLWebClientAutoConfiguration.class);
    private final GraphQLClientProperties graphqlClientProperties;

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(WebClient.Builder clientBuilder, @Autowired(required=false) ReactiveClientRegistrationRepository clientRegistrations) {
        clientBuilder.baseUrl(this.graphqlClientProperties.getUrl());
        if (this.isGraphQLClientRegistrationPresent(clientRegistrations)) {
            clientBuilder.filter((ExchangeFilterFunction)this.createOAuthFilter(clientRegistrations));
        }
        return clientBuilder.build();
    }

    @NonNull
    private ServerOAuth2AuthorizedClientExchangeFilterFunction createOAuthFilter(ReactiveClientRegistrationRepository clientRegistrations) {
        InMemoryReactiveOAuth2AuthorizedClientService clientService = new InMemoryReactiveOAuth2AuthorizedClientService(clientRegistrations);
        AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager authorizedClientManager = new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(clientRegistrations, (ReactiveOAuth2AuthorizedClientService)clientService);
        ServerOAuth2AuthorizedClientExchangeFilterFunction oauth = new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)authorizedClientManager);
        oauth.setDefaultClientRegistrationId("graphql");
        return oauth;
    }

    private boolean isGraphQLClientRegistrationPresent(ReactiveClientRegistrationRepository clientRegistrations) {
        return clientRegistrations != null && clientRegistrations.findByRegistrationId("graphql").blockOptional().isPresent();
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLWebClient graphQLWebClient(WebClient webClient, ObjectMapper objectMapper) {
        return new GraphQLWebClientImpl(webClient, objectMapper);
    }

    @Generated
    public GraphQLWebClientAutoConfiguration(GraphQLClientProperties graphqlClientProperties) {
        this.graphqlClientProperties = graphqlClientProperties;
    }
}

