/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webclient.boot;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthenticationMethod;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

@Primary
@ConfigurationProperties(prefix="graphql.client.oauth2")
class OAuth2ClientRegistrationProperties {
    private String provider;
    private String clientId;
    private String clientSecret;
    private String clientAuthenticationMethod;
    private String authorizationGrantType = "client_credentials";
    private String redirectUri;
    private Set<String> scope;
    private String clientName;
    private String authorizationUri;
    private String tokenUri;
    private String userInfoUri;
    private String userInfoAuthenticationMethod;
    private String userNameAttribute;
    private String jwkSetUri;
    private String issuerUri;

    Optional<ClientRegistration> getClientRegistration() {
        if (this.clientId != null) {
            ClientRegistration.Builder builder = ClientRegistration.withRegistrationId((String)"graphql").clientId(this.getClientId()).clientSecret(this.getClientSecret()).redirectUri(this.getRedirectUri()).scope(this.getScope()).clientName(this.getClientName()).authorizationUri(this.getAuthorizationUri()).tokenUri(this.getTokenUri()).userInfoUri(this.getUserInfoUri()).jwkSetUri(this.getJwkSetUri());
            Optional.ofNullable(this.getClientAuthenticationMethod()).map(ClientAuthenticationMethod::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).clientAuthenticationMethod(arg_0));
            Optional.ofNullable(this.getAuthorizationGrantType()).map(AuthorizationGrantType::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).authorizationGrantType(arg_0));
            Optional.ofNullable(this.getUserInfoAuthenticationMethod()).map(AuthenticationMethod::new).ifPresent(arg_0 -> ((ClientRegistration.Builder)builder).userInfoAuthenticationMethod(arg_0));
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }

    @Generated
    public OAuth2ClientRegistrationProperties() {
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    @Generated
    public String getAuthorizationGrantType() {
        return this.authorizationGrantType;
    }

    @Generated
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Generated
    public Set<String> getScope() {
        return this.scope;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    @Generated
    public String getTokenUri() {
        return this.tokenUri;
    }

    @Generated
    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    @Generated
    public String getUserInfoAuthenticationMethod() {
        return this.userInfoAuthenticationMethod;
    }

    @Generated
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    @Generated
    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    @Generated
    public String getIssuerUri() {
        return this.issuerUri;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    @Generated
    public void setAuthorizationGrantType(String authorizationGrantType) {
        this.authorizationGrantType = authorizationGrantType;
    }

    @Generated
    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @Generated
    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    @Generated
    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    @Generated
    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    @Generated
    public void setUserInfoAuthenticationMethod(String userInfoAuthenticationMethod) {
        this.userInfoAuthenticationMethod = userInfoAuthenticationMethod;
    }

    @Generated
    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    @Generated
    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    @Generated
    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ClientRegistrationProperties)) {
            return false;
        }
        OAuth2ClientRegistrationProperties other = (OAuth2ClientRegistrationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$clientAuthenticationMethod = this.getClientAuthenticationMethod();
        String other$clientAuthenticationMethod = other.getClientAuthenticationMethod();
        if (this$clientAuthenticationMethod == null ? other$clientAuthenticationMethod != null : !this$clientAuthenticationMethod.equals(other$clientAuthenticationMethod)) {
            return false;
        }
        String this$authorizationGrantType = this.getAuthorizationGrantType();
        String other$authorizationGrantType = other.getAuthorizationGrantType();
        if (this$authorizationGrantType == null ? other$authorizationGrantType != null : !this$authorizationGrantType.equals(other$authorizationGrantType)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        Set<String> this$scope = this.getScope();
        Set<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$authorizationUri = this.getAuthorizationUri();
        String other$authorizationUri = other.getAuthorizationUri();
        if (this$authorizationUri == null ? other$authorizationUri != null : !this$authorizationUri.equals(other$authorizationUri)) {
            return false;
        }
        String this$tokenUri = this.getTokenUri();
        String other$tokenUri = other.getTokenUri();
        if (this$tokenUri == null ? other$tokenUri != null : !this$tokenUri.equals(other$tokenUri)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        if (this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri)) {
            return false;
        }
        String this$userInfoAuthenticationMethod = this.getUserInfoAuthenticationMethod();
        String other$userInfoAuthenticationMethod = other.getUserInfoAuthenticationMethod();
        if (this$userInfoAuthenticationMethod == null ? other$userInfoAuthenticationMethod != null : !this$userInfoAuthenticationMethod.equals(other$userInfoAuthenticationMethod)) {
            return false;
        }
        String this$userNameAttribute = this.getUserNameAttribute();
        String other$userNameAttribute = other.getUserNameAttribute();
        if (this$userNameAttribute == null ? other$userNameAttribute != null : !this$userNameAttribute.equals(other$userNameAttribute)) {
            return false;
        }
        String this$jwkSetUri = this.getJwkSetUri();
        String other$jwkSetUri = other.getJwkSetUri();
        if (this$jwkSetUri == null ? other$jwkSetUri != null : !this$jwkSetUri.equals(other$jwkSetUri)) {
            return false;
        }
        String this$issuerUri = this.getIssuerUri();
        String other$issuerUri = other.getIssuerUri();
        return !(this$issuerUri == null ? other$issuerUri != null : !this$issuerUri.equals(other$issuerUri));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2ClientRegistrationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $clientAuthenticationMethod = this.getClientAuthenticationMethod();
        result = result * 59 + ($clientAuthenticationMethod == null ? 43 : $clientAuthenticationMethod.hashCode());
        String $authorizationGrantType = this.getAuthorizationGrantType();
        result = result * 59 + ($authorizationGrantType == null ? 43 : $authorizationGrantType.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        Set<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $authorizationUri = this.getAuthorizationUri();
        result = result * 59 + ($authorizationUri == null ? 43 : $authorizationUri.hashCode());
        String $tokenUri = this.getTokenUri();
        result = result * 59 + ($tokenUri == null ? 43 : $tokenUri.hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
        String $userInfoAuthenticationMethod = this.getUserInfoAuthenticationMethod();
        result = result * 59 + ($userInfoAuthenticationMethod == null ? 43 : $userInfoAuthenticationMethod.hashCode());
        String $userNameAttribute = this.getUserNameAttribute();
        result = result * 59 + ($userNameAttribute == null ? 43 : $userNameAttribute.hashCode());
        String $jwkSetUri = this.getJwkSetUri();
        result = result * 59 + ($jwkSetUri == null ? 43 : $jwkSetUri.hashCode());
        String $issuerUri = this.getIssuerUri();
        result = result * 59 + ($issuerUri == null ? 43 : $issuerUri.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OAuth2ClientRegistrationProperties(provider=" + this.getProvider() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", clientAuthenticationMethod=" + this.getClientAuthenticationMethod() + ", authorizationGrantType=" + this.getAuthorizationGrantType() + ", redirectUri=" + this.getRedirectUri() + ", scope=" + this.getScope() + ", clientName=" + this.getClientName() + ", authorizationUri=" + this.getAuthorizationUri() + ", tokenUri=" + this.getTokenUri() + ", userInfoUri=" + this.getUserInfoUri() + ", userInfoAuthenticationMethod=" + this.getUserInfoAuthenticationMethod() + ", userNameAttribute=" + this.getUserNameAttribute() + ", jwkSetUri=" + this.getJwkSetUri() + ", issuerUri=" + this.getIssuerUri() + ")";
    }
}

