/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webclient.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.spring.webclient.boot.GraphQLRequest;
import graphql.kickstart.spring.webclient.boot.GraphQLResponse;
import graphql.kickstart.spring.webclient.boot.GraphQLWebClient;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class GraphQLWebClientImpl
implements GraphQLWebClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLWebClientImpl.class);
    private final WebClient webClient;
    private final ObjectMapper objectMapper;

    @Override
    public <T> Mono<T> post(String resource, Class<T> returnType) {
        return this.post(resource, null, returnType);
    }

    @Override
    public <T> Mono<T> post(String resource, Map<String, Object> variables, Class<T> returnType) {
        return this.post(resource, variables).flatMap(it -> {
            it.validateNoErrors();
            return Mono.justOrEmpty(it.getFirst(returnType));
        });
    }

    @Override
    public Mono<GraphQLResponse> post(GraphQLRequest request) {
        WebClient.RequestBodySpec spec = this.webClient.post().contentType(MediaType.APPLICATION_JSON);
        request.getHeaders().forEach((header, values) -> spec.header(header, values.toArray(new String[0])));
        return spec.bodyValue((Object)request.getRequestBody()).retrieve().bodyToMono(String.class).map(it -> new GraphQLResponse((String)it, this.objectMapper));
    }

    @Override
    public <T> Flux<T> flux(String resource, Class<T> returnType) {
        return this.flux(resource, null, returnType);
    }

    @Override
    public <T> Flux<T> flux(String resource, Map<String, Object> variables, Class<T> returnType) {
        return this.post(resource, variables).map(it -> it.getFirstList(returnType)).flatMapMany(Flux::fromIterable);
    }

    private Mono<GraphQLResponse> post(String resource, Map<String, Object> variables) {
        GraphQLRequest request = GraphQLRequest.builder().resource(resource).variables(variables).build();
        return this.post(request);
    }

    @Generated
    public GraphQLWebClientImpl(WebClient webClient, ObjectMapper objectMapper) {
        this.webClient = webClient;
        this.objectMapper = objectMapper;
    }
}

