/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webclient.boot;

import graphql.kickstart.spring.webclient.boot.GraphQLRequest;
import graphql.kickstart.spring.webclient.boot.GraphQLRequestBody;
import graphql.kickstart.spring.webclient.boot.GraphQLRequestImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StreamUtils;

public class GraphQLRequestBuilder {
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final HttpHeaders headers = new HttpHeaders();
    private final GraphQLRequestBody.GraphQLRequestBodyBuilder bodyBuilder = GraphQLRequestBody.builder();

    GraphQLRequestBuilder() {
    }

    public GraphQLRequestBuilder attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public GraphQLRequestBuilder header(String name, String ... values) {
        this.headers.addAll(name, Arrays.asList(values));
        return this;
    }

    public GraphQLRequestBuilder resource(String resource) {
        return this.query(this.loadQuery(resource));
    }

    private String loadQuery(String path) {
        return this.loadResource((Resource)new ClassPathResource(path));
    }

    private String loadResource(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public GraphQLRequestBuilder query(String query) {
        this.bodyBuilder.query(query);
        return this;
    }

    public GraphQLRequestBuilder variables(Object variables) {
        this.bodyBuilder.variables(variables);
        return this;
    }

    public GraphQLRequestBuilder operationName(String operationName) {
        this.bodyBuilder.operationName(operationName);
        return this;
    }

    public GraphQLRequest build() {
        return new GraphQLRequestImpl(this.attributes, this.headers, this.bodyBuilder.build());
    }
}

