/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.webclient.boot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import graphql.kickstart.spring.webclient.boot.GraphQLClientException;
import graphql.kickstart.spring.webclient.boot.GraphQLError;
import graphql.kickstart.spring.webclient.boot.GraphQLErrorsException;
import graphql.kickstart.spring.webclient.boot.GraphQLResponseReadException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class GraphQLResponse {
    public static final String ERRORS_FIELD = "errors";
    private final String rawResponse;
    private final JsonNode data;
    private final List<GraphQLError> errors;
    private final ObjectMapper objectMapper;
    private ReadContext readContext;

    GraphQLResponse(String rawResponse, ObjectMapper objectMapper) {
        this.rawResponse = rawResponse;
        this.objectMapper = objectMapper;
        JsonNode tree = this.readTree(rawResponse);
        this.errors = this.readErrors(tree);
        this.data = tree.get("data");
    }

    private JsonNode readTree(String rawResponse) {
        try {
            return this.objectMapper.readTree(rawResponse);
        }
        catch (JsonProcessingException e) {
            throw new GraphQLClientException("Cannot read response '" + rawResponse + "'", e);
        }
    }

    private List<GraphQLError> readErrors(JsonNode tree) {
        if (tree.hasNonNull(ERRORS_FIELD)) {
            return this.convertList(tree.get(ERRORS_FIELD), GraphQLError.class);
        }
        return Collections.emptyList();
    }

    private <T> List<T> convertList(JsonNode node, Class<T> type) {
        return (List)this.objectMapper.convertValue((Object)node, this.constructListType(type));
    }

    private JavaType constructListType(Class<?> type) {
        return this.objectMapper.getTypeFactory().constructCollectionType(List.class, type);
    }

    public <T> T get(String fieldName, Class<T> type) {
        if (this.data.hasNonNull(fieldName)) {
            return (T)this.objectMapper.convertValue((Object)this.data.get(fieldName), type);
        }
        return null;
    }

    public <T> T getAt(String path, Class<T> type) throws GraphQLResponseReadException {
        try {
            return (T)this.getReadContext().read(path, type, new Predicate[0]);
        }
        catch (JsonPathException e) {
            throw new GraphQLResponseReadException("Failed to read part of GraphQL response.", e);
        }
    }

    public <T> T getFirst(Class<T> type) {
        return this.getFirstDataEntry().map(it -> this.objectMapper.convertValue(it, type)).orElse(null);
    }

    private Optional<JsonNode> getFirstDataEntry() {
        if (!this.data.isEmpty()) {
            return Optional.ofNullable((JsonNode)((Map.Entry)this.data.fields().next()).getValue());
        }
        return Optional.empty();
    }

    public <T> List<T> getList(String fieldName, Class<T> type) {
        if (this.data.hasNonNull(fieldName)) {
            return this.convertList(this.data.get(fieldName), type);
        }
        return Collections.emptyList();
    }

    public <T> List<T> getListAt(String path, Class<T> itemType) throws GraphQLResponseReadException {
        return (List)this.objectMapper.convertValue(this.getAt(path), this.constructListType(itemType));
    }

    public <T> List<T> getFirstList(Class<T> type) {
        return this.getFirstDataEntry().map(it -> this.convertList((JsonNode)it, type)).map(List.class::cast).orElseGet(Collections::emptyList);
    }

    public <T> T getAt(String path) throws GraphQLResponseReadException {
        try {
            return (T)this.getReadContext().read(path, new Predicate[0]);
        }
        catch (JsonPathException e) {
            throw new GraphQLResponseReadException("Failed to read part of GraphQL response.", e);
        }
    }

    public void validateNoErrors() {
        if (!this.errors.isEmpty()) {
            throw new GraphQLErrorsException(this.errors);
        }
    }

    public ReadContext getReadContext() {
        if (this.readContext == null) {
            Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider(this.objectMapper)).build();
            this.readContext = JsonPath.parse((String)this.data.toString());
        }
        return this.readContext;
    }

    @Generated
    public String getRawResponse() {
        return this.rawResponse;
    }

    @Generated
    public List<GraphQLError> getErrors() {
        return this.errors;
    }
}

