/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.playground.boot;

import graphql.kickstart.playground.boot.PlaygroundWebFluxControllerAdvice;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.thymeleaf.spring5.ISpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.SpringWebFluxTemplateEngine;
import org.thymeleaf.spring5.view.reactive.ThymeleafReactiveViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@Import(value={PlaygroundWebFluxControllerAdvice.class})
@ConditionalOnClass(value={WebFluxConfigurer.class})
@ConditionalOnProperty(value={"graphql.playground.enabled"}, havingValue="true", matchIfMissing=true)
public class PlaygroundWebFluxAutoConfiguration
implements WebFluxConfigurer {
    private final ApplicationContext applicationContext;

    @Bean
    public RouterFunction<ServerResponse> playgroundStaticFilesRouter() {
        return RouterFunctions.resources((String)"/vendor/playground/**", (Resource)new ClassPathResource("static/vendor/playground/"));
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
        ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
        templateResolver.setPrefix("templates/");
        templateResolver.setSuffix(".html");
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        templateResolver.setOrder(Integer.valueOf(1));
        templateResolver.setCheckExistence(true);
        SpringWebFluxTemplateEngine springWebFluxTemplateEngine = new SpringWebFluxTemplateEngine();
        springWebFluxTemplateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        ThymeleafReactiveViewResolver thymeleafReactiveViewResolver = new ThymeleafReactiveViewResolver();
        thymeleafReactiveViewResolver.setDefaultCharset(StandardCharsets.UTF_8);
        thymeleafReactiveViewResolver.setApplicationContext(this.applicationContext);
        thymeleafReactiveViewResolver.setTemplateEngine((ISpringWebFluxTemplateEngine)springWebFluxTemplateEngine);
        thymeleafReactiveViewResolver.setViewNames(new String[]{"playground"});
        registry.viewResolver((ViewResolver)thymeleafReactiveViewResolver);
    }

    @Generated
    public PlaygroundWebFluxAutoConfiguration(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

