/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.playground.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.playground.boot.PlaygroundPropertiesConfiguration;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class PlaygroundController {
    private static final String CDN_ROOT = "https://cdn.jsdelivr.net/npm/graphql-playground-react";
    private static final String CSS_PATH = "static/css/index.css";
    private static final String FAVICON_PATH = "favicon.png";
    private static final String SCRIPT_PATH = "static/js/middleware.js";
    private static final String LOGO_PATH = "logo.png";
    private static final String CSS_URL_ATTRIBUTE_NAME = "cssUrl";
    private static final String FAVICON_URL_ATTRIBUTE_NAME = "faviconUrl";
    private static final String SCRIPT_URL_ATTRIBUTE_NAME = "scriptUrl";
    private static final String LOGO_URL_ATTRIBUTE_NAME = "logoUrl";
    private final PlaygroundPropertiesConfiguration propertiesConfiguration;
    private final ObjectMapper objectMapper;

    @GetMapping(value={"${graphql.playground.mapping:/playground}"})
    public String playground(Model model, HttpServletRequest request) {
        if (this.propertiesConfiguration.getPlayground().getCdn().isEnabled()) {
            this.setCdnUrls(model);
        } else {
            this.setLocalAssetUrls(model);
        }
        model.addAttribute("pageTitle", (Object)this.propertiesConfiguration.getPlayground().getPageTitle());
        model.addAttribute("properties", (Object)this.objectMapper.valueToTree((Object)this.propertiesConfiguration.getPlayground()));
        model.addAttribute("_csrf", request.getAttribute("_csrf"));
        return "playground";
    }

    private String getCdnUrl(String assetPath) {
        return String.format("%s@%s/build/%s", CDN_ROOT, this.propertiesConfiguration.getPlayground().getCdn().getVersion(), assetPath);
    }

    private String getLocalUrl(String assetPath) {
        return Paths.get(this.propertiesConfiguration.getPlayground().getStaticPath().getBase(), assetPath).toString().replace('\\', '/');
    }

    private void setCdnUrls(Model model) {
        model.addAttribute(CSS_URL_ATTRIBUTE_NAME, (Object)this.getCdnUrl(CSS_PATH));
        model.addAttribute(FAVICON_URL_ATTRIBUTE_NAME, (Object)this.getCdnUrl(FAVICON_PATH));
        model.addAttribute(SCRIPT_URL_ATTRIBUTE_NAME, (Object)this.getCdnUrl(SCRIPT_PATH));
        model.addAttribute(LOGO_URL_ATTRIBUTE_NAME, (Object)this.getCdnUrl(LOGO_PATH));
    }

    private void setLocalAssetUrls(Model model) {
        model.addAttribute(CSS_URL_ATTRIBUTE_NAME, (Object)this.getLocalUrl(CSS_PATH));
        model.addAttribute(FAVICON_URL_ATTRIBUTE_NAME, (Object)this.getLocalUrl(FAVICON_PATH));
        model.addAttribute(SCRIPT_URL_ATTRIBUTE_NAME, (Object)this.getLocalUrl(SCRIPT_PATH));
        model.addAttribute(LOGO_URL_ATTRIBUTE_NAME, (Object)this.getLocalUrl(LOGO_PATH));
    }

    public PlaygroundController(PlaygroundPropertiesConfiguration propertiesConfiguration, ObjectMapper objectMapper) {
        this.propertiesConfiguration = propertiesConfiguration;
        this.objectMapper = objectMapper;
    }
}

