/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.voyager.boot;

import graphql.kickstart.voyager.boot.ReactiveVoyagerController;
import graphql.kickstart.voyager.boot.VoyagerIndexHtmlTemplate;
import graphql.kickstart.voyager.boot.VoyagerPropertiesConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(value={"voyager.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={VoyagerPropertiesConfiguration.class})
public class ReactiveVoyagerAutoConfiguration {
    @Bean
    ReactiveVoyagerController voyagerController() {
        return new ReactiveVoyagerController();
    }

    @Bean
    public RouterFunction<ServerResponse> voyagerStaticFilesRouter() {
        return RouterFunctions.resources((String)"/vendor/voyager/**", (Resource)new ClassPathResource("static/vendor/voyager/"));
    }

    @Bean
    VoyagerIndexHtmlTemplate voyagerIndexHtmlTemplate(VoyagerPropertiesConfiguration voyagerPropertiesConfiguration) {
        return new VoyagerIndexHtmlTemplate(voyagerPropertiesConfiguration);
    }
}

