/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.datetime;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.function.Function;

@Internal
public class AccurateDurationScalar {
    public static final GraphQLScalarType INSTANCE;

    private AccurateDurationScalar() {
    }

    static {
        Coercing<Duration, String> coercing = new Coercing<Duration, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                Duration duration;
                if (input instanceof Duration) {
                    duration = (Duration)input;
                } else if (input instanceof String) {
                    duration = this.parseDuration(input.toString(), CoercingSerializeException::new);
                } else {
                    throw new CoercingSerializeException("Expected something we can convert to 'java.time.Duration' but was '" + Kit.typeName(input) + "'.");
                }
                return duration.toString();
            }

            public Duration parseValue(Object input) throws CoercingParseValueException {
                Duration duration;
                if (input instanceof Duration) {
                    duration = (Duration)input;
                } else if (input instanceof String) {
                    duration = this.parseDuration(input.toString(), CoercingParseValueException::new);
                } else {
                    throw new CoercingParseValueException("Expected a 'String' but was '" + Kit.typeName(input) + "'.");
                }
                return duration;
            }

            public Duration parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseDuration(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }

            private Duration parseDuration(String s, Function<String, RuntimeException> exceptionMaker) {
                try {
                    return Duration.parse(s);
                }
                catch (DateTimeParseException e) {
                    throw exceptionMaker.apply("Invalid ISO 8601 value : '" + s + "'. because of : '" + e.getMessage() + "'");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("AccurateDuration").description("A ISO 8601 duration scalar with only day, hour, minute, second components.").specifiedByUrl("https://scalars.graphql.org/AlexandreCarlton/accurate-duration").coercing((Coercing)coercing).build();
    }
}

