/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.uri;

import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;

@Internal
public final class UriScalar {
    public static final GraphQLScalarType INSTANCE;

    private UriScalar() {
    }

    private static Optional<URI> toURI(Object input) {
        if (input instanceof URI) {
            return Optional.of((URI)input);
        }
        if (input instanceof URL) {
            try {
                return Optional.of(((URL)input).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        } else if (input instanceof File) {
            return Optional.of(((File)input).toURI());
        }
        return Optional.empty();
    }

    static {
        Coercing<URI, URI> coercing = new Coercing<URI, URI>(){

            public URI serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                Optional<URI> uri = input instanceof String ? Optional.of(this.parseURI(input.toString(), CoercingSerializeException::new)) : UriScalar.toURI(input);
                if (uri.isPresent()) {
                    return uri.get();
                }
                throw new CoercingSerializeException("Expected a 'URI' like object but was '" + Kit.typeName(input) + "'.");
            }

            public URI parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                if (!(input instanceof String)) {
                    Optional<URI> uri = UriScalar.toURI(input);
                    if (uri.isEmpty()) {
                        throw new CoercingParseValueException("Expected a 'URI' like object but was '" + Kit.typeName(input) + "'.");
                    }
                    return uri.get();
                }
                String uriStr = String.valueOf(input);
                return this.parseURI(uriStr, CoercingParseValueException::new);
            }

            public URI parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseURI(((StringValue)input).getValue(), CoercingParseLiteralException::new);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                URI uri = this.serialize(input, graphQLContext, locale);
                return StringValue.newStringValue((String)uri.toString()).build();
            }

            private URI parseURI(String input, Function<String, RuntimeException> exceptionMaker) {
                try {
                    return new URI(input);
                }
                catch (URISyntaxException e) {
                    throw exceptionMaker.apply("Invalid URI value : '" + input + "'.");
                }
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Uri").description("A Uri scalar").coercing((Coercing)coercing).build();
    }
}

