/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.numeric;

import graphql.Internal;
import graphql.scalars.numeric.FloatCoercing;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.function.Function;

@Internal
public final class NonPositiveFloatScalar {
    public static final GraphQLScalarType INSTANCE = GraphQLScalarType.newScalar().name("NonPositiveFloat").description("An Float scalar that must be less than or equal to zero").coercing((Coercing)new FloatCoercing(){

        @Override
        protected Double check(Double d, Function<String, RuntimeException> exceptionMaker) {
            if (d > 0.0) {
                throw exceptionMaker.apply("The value must be less than or equal to zero");
            }
            return d;
        }
    }).build();

    private NonPositiveFloatScalar() {
    }
}

