/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints;

import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Arrays;
import java.util.List;

public class Documentation {
    private final String description;
    private final String example;
    private final String directiveSDL;
    private final TypeDefinitionRegistry directiveDeclaration;
    private final String messageTemplate;
    private final List<String> applicableTypeNames;

    private Documentation(Builder builder) {
        this.description = builder.description;
        this.example = builder.example;
        this.directiveSDL = builder.directiveSDL;
        this.directiveDeclaration = new SchemaParser().parse(builder.directiveSDL);
        this.messageTemplate = builder.messageTemplate;
        this.applicableTypeNames = builder.applicableTypeNames;
    }

    public static Builder newDocumentation() {
        return new Builder();
    }

    public String getDescription() {
        return this.description;
    }

    public String getExample() {
        return this.example;
    }

    public String getDirectiveSDL() {
        return this.directiveSDL;
    }

    public TypeDefinitionRegistry getDirectiveDeclaration() {
        return this.directiveDeclaration;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public List<String> getApplicableTypeNames() {
        return this.applicableTypeNames;
    }

    public static class Builder {
        private String description;
        private String example;
        private String directiveSDL;
        private String messageTemplate;
        private List<String> applicableTypeNames;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder example(String example) {
            this.example = example;
            return this;
        }

        public Builder directiveSDL(String format, Object ... args) {
            this.directiveSDL = String.format(format, args);
            return this;
        }

        public Builder messageTemplate(String messageTemplate) {
            this.messageTemplate = messageTemplate;
            return this;
        }

        public Builder applicableTypeNames(List<String> applicableTypeNames) {
            this.applicableTypeNames = applicableTypeNames;
            return this;
        }

        public Builder applicableTypeNames(String ... applicableTypeNames) {
            this.applicableTypeNames = Arrays.asList(applicableTypeNames);
            return this;
        }

        public Documentation build() {
            return new Documentation(this);
        }
    }
}

