/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.Scalars;
import graphql.scalars.ExtendedScalars;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLScalarType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.rules.ValidationEnvironment;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class AbstractDecimalMinMaxConstraint
extends AbstractDirectiveConstraint {
    public AbstractDecimalMinMaxConstraint(String name) {
        super(name);
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, Scalars.GraphQLString, ExtendedScalars.GraphQLByte, ExtendedScalars.GraphQLShort, Scalars.GraphQLInt, ExtendedScalars.GraphQLLong, ExtendedScalars.GraphQLBigDecimal, ExtendedScalars.GraphQLBigInteger, Scalars.GraphQLFloat);
    }

    public List<String> getApplicableTypeNames() {
        return Stream.of(Scalars.GraphQLString, ExtendedScalars.GraphQLByte, ExtendedScalars.GraphQLShort, Scalars.GraphQLInt, ExtendedScalars.GraphQLLong, ExtendedScalars.GraphQLBigDecimal, ExtendedScalars.GraphQLBigInteger, Scalars.GraphQLFloat).map(GraphQLScalarType::getName).collect(Collectors.toList());
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        boolean isOK;
        Object validatedValue = validationEnvironment.getValidatedValue();
        if (validatedValue == null) {
            return Collections.emptyList();
        }
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        String value = this.getStrArg(directive, "value");
        boolean inclusive = this.getBoolArg(directive, "inclusive");
        try {
            BigDecimal directiveBD = new BigDecimal(value);
            BigDecimal argBD = this.asBigDecimal(validatedValue);
            int comparisonResult = argBD.compareTo(directiveBD);
            isOK = this.isOK(inclusive, comparisonResult);
        }
        catch (NumberFormatException nfe) {
            isOK = false;
        }
        if (!isOK) {
            return this.mkError(validationEnvironment, directive, this.mkMessageParams(validatedValue, validationEnvironment, "value", validatedValue, "inclusive", inclusive));
        }
        return Collections.emptyList();
    }

    protected abstract boolean isOK(boolean var1, int var2);
}

