/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints;

import graphql.GraphQLError;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.rules.ValidationEnvironment;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphQLListElementValidator {
    public boolean appliesToType(GraphQLInputType inputType, Function<GraphQLInputType, Boolean> appliesToTypeOrListElement) {
        if (GraphQLTypeUtil.isList((GraphQLType)inputType)) {
            return appliesToTypeOrListElement.apply((GraphQLInputType)GraphQLTypeUtil.unwrapAll((GraphQLType)inputType));
        }
        return appliesToTypeOrListElement.apply(inputType);
    }

    public List<GraphQLError> runConstraintOnListElements(ValidationEnvironment validationEnvironment, Function<ValidationEnvironment, List<GraphQLError>> runConstraintOnElement) {
        Object validatedValue = validationEnvironment.getValidatedValue();
        if (validatedValue instanceof Collection) {
            AtomicInteger index = new AtomicInteger(0);
            return ((Collection)validatedValue).stream().flatMap(item -> item == null ? Stream.empty() : ((List)runConstraintOnElement.apply(validationEnvironment.transform(environment -> environment.validatedValue(item).validatedPath(validationEnvironment.getValidatedPath().segment(index.getAndIncrement())).validatedType((GraphQLInputType)GraphQLTypeUtil.unwrapAll((GraphQLType)validationEnvironment.getValidatedType()))))).stream()).collect(Collectors.toList());
        }
        return runConstraintOnElement.apply(validationEnvironment);
    }
}

