/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.GraphQLError;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.validation.constraints.AbstractDirectiveConstraint;
import graphql.validation.constraints.Documentation;
import graphql.validation.constraints.GraphQLScalars;
import graphql.validation.rules.ValidationEnvironment;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class RangeConstraint
extends AbstractDirectiveConstraint {
    public RangeConstraint() {
        super("Range");
    }

    @Override
    public Documentation getDocumentation() {
        return Documentation.newDocumentation().messageTemplate(this.getMessageTemplate()).description("The element range must be between the specified `min` and `max` boundaries (inclusive).  It accepts numbers and strings that represent numerical values.").example("driver( milesTravelled : Int @Range( min : 1000, max : 100000)) : DriverDetails").applicableTypes(GraphQLScalars.GRAPHQL_NUMBER_AND_STRING_TYPES).directiveSDL("directive @Range(min : Int = 0, max : Int = %d, message : String = \"%s\") on ARGUMENT_DEFINITION | INPUT_FIELD_DEFINITION", Integer.MAX_VALUE, this.getMessageTemplate()).build();
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isOneOfTheseTypes(inputType, GraphQLScalars.GRAPHQL_NUMBER_AND_STRING_TYPES);
    }

    @Override
    protected List<GraphQLError> runConstraint(ValidationEnvironment validationEnvironment) {
        boolean isOK;
        Object validatedValue = validationEnvironment.getValidatedValue();
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        BigDecimal min = this.asBigDecimal(this.getIntArg(directive, "min"));
        BigDecimal max = this.asBigDecimal(this.getIntArg(directive, "max"));
        try {
            BigDecimal argBD = this.asBigDecimal(validatedValue);
            isOK = this.isOK(argBD, min, max);
        }
        catch (NumberFormatException nfe) {
            isOK = false;
        }
        if (!isOK) {
            return this.mkError(validationEnvironment, "min", min, "max", max);
        }
        return Collections.emptyList();
    }

    private boolean isOK(BigDecimal argBD, BigDecimal min, BigDecimal max) {
        if (argBD.compareTo(max) > 0) {
            return false;
        }
        return argBD.compareTo(min) >= 0;
    }

    @Override
    protected boolean appliesToListElements() {
        return true;
    }
}

