/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.interpolation;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.ResultPath;
import graphql.schema.GraphQLDirective;
import graphql.validation.el.StandardELVariables;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.rules.ValidationEnvironment;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.validation.Constraint;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.util.annotation.ConstraintAnnotationDescriptor;
import org.hibernate.validator.messageinterpolation.ExpressionLanguageFeatureLevel;
import org.hibernate.validator.resourceloading.PlatformResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;

public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private ResourceBundleLocator userResourceBundleLocator = new PlatformResourceBundleLocator("ValidationMessages");
    private ResourceBundleLocator systemResourceBundleLocator = new PlatformResourceBundleLocator("graphql.validation.ValidationMessages");
    private Locale defaultLocale = Locale.getDefault();

    protected ErrorClassification buildErrorClassification(String messageTemplate, Map<String, Object> messageParams, ValidationEnvironment validationEnvironment) {
        ResultPath fieldOrArgumentPath = validationEnvironment.getValidatedPath();
        GraphQLDirective directive = validationEnvironment.getContextObject(GraphQLDirective.class, new Object[0]);
        return new ValidationErrorType(fieldOrArgumentPath, directive);
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return null;
    }

    @Override
    public GraphQLError interpolate(String messageTemplate, Map<String, Object> messageParams, ValidationEnvironment validationEnvironment) {
        ErrorClassification errorClassification = this.buildErrorClassification(messageTemplate, messageParams, validationEnvironment);
        String message = this.interpolateMessageImpl(messageTemplate, messageParams, validationEnvironment);
        GraphqlErrorBuilder errorBuilder = GraphqlErrorBuilder.newError().message(message, new Object[0]).errorType(errorClassification).path(validationEnvironment.getExecutionPath());
        if (validationEnvironment.getLocation() != null) {
            errorBuilder.location(validationEnvironment.getLocation());
        }
        return errorBuilder.build();
    }

    private String interpolateMessageImpl(String messageTemplate, Map<String, Object> messageParams, ValidationEnvironment validationEnvironment) {
        Locale locale = validationEnvironment.getLocale() == null ? this.defaultLocale : validationEnvironment.getLocale();
        messageTemplate = this.loadMessageResource(messageTemplate, locale);
        MessageInterpolatorContext context = this.buildHibernateContext(messageParams, validationEnvironment);
        if (locale == null) {
            return this.hibernateInterpolator().interpolate(messageTemplate, (MessageInterpolator.Context)context);
        }
        return this.hibernateInterpolator().interpolate(messageTemplate, (MessageInterpolator.Context)context, locale);
    }

    private String loadMessageResource(String messageTemplate, Locale locale) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        Optional<String> bundleMessage = this.loadMessageFromBundle(messageTemplate, resourceBundle);
        if (!bundleMessage.isPresent() && !(bundleMessage = this.loadMessageFromBundle(messageTemplate, this.userResourceBundleLocator.getResourceBundle(locale))).isPresent()) {
            bundleMessage = this.loadMessageFromBundle(messageTemplate, this.systemResourceBundleLocator.getResourceBundle(locale));
        }
        return bundleMessage.orElse(messageTemplate);
    }

    private Optional<String> loadMessageFromBundle(String messageTemplate, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(resourceBundle.getString(messageTemplate));
        }
        catch (MissingResourceException ignored) {
            return Optional.empty();
        }
    }

    private MessageInterpolatorContext buildHibernateContext(Map<String, Object> messageParams, ValidationEnvironment validationEnvironment) {
        Object validatedValue = validationEnvironment.getValidatedValue();
        ConstraintAnnotationDescriptor annotationDescriptor = new ConstraintAnnotationDescriptor.Builder(BridgeAnnotation.class).build();
        ConstraintDescriptorImpl constraintDescriptor = new ConstraintDescriptorImpl(ConstraintHelper.forAllBuiltinConstraints(), null, annotationDescriptor, ConstraintLocation.ConstraintLocationKind.FIELD, ConstraintDescriptorImpl.ConstraintType.GENERIC);
        Map<String, Object> expressionVariables = StandardELVariables.standardELVars(validationEnvironment);
        Class rootBeanType = null;
        Path propertyPath = null;
        return new MessageInterpolatorContext((ConstraintDescriptor)constraintDescriptor, validatedValue, rootBeanType, propertyPath, messageParams, expressionVariables, ExpressionLanguageFeatureLevel.BEAN_PROPERTIES, true);
    }

    private org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator hibernateInterpolator() {
        return new org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator();
    }

    private static class ValidationErrorType
    implements ErrorClassification {
        private final ResultPath fieldOrArgumentPath;
        private final GraphQLDirective directive;

        ValidationErrorType(ResultPath fieldOrArgumentPath, GraphQLDirective directive) {
            this.fieldOrArgumentPath = fieldOrArgumentPath;
            this.directive = directive;
        }

        public Object toSpecification(GraphQLError error) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", "ExtendedValidationError");
            map.put("validatedPath", this.fieldOrArgumentPath.toList());
            if (this.directive != null) {
                map.put("constraint", "@" + this.directive.getName());
            }
            return map;
        }
    }

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={})
    private static @interface BridgeAnnotation {
        public String message() default "";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

