/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.GraphQLJavaToolsAutoConfiguration;
import com.oembedler.moon.graphql.boot.GraphQLServletProperties;
import com.oembedler.moon.graphql.boot.SpringGraphQLCommonAutoConfiguration;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleExecutionStrategy;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLOperationListener;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.SimpleGraphQLServlet;
import java.util.List;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnBean(value={GraphQLSchema.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class, SpringGraphQLCommonAutoConfiguration.class, WebMvcConfigurerAdapter.class})
@EnableConfigurationProperties(value={GraphQLServletProperties.class})
public class GraphQLWebAutoConfiguration {
    @Autowired
    private GraphQLServletProperties graphQLServletProperties;
    @Autowired(required=false)
    private List<GraphQLOperationListener> operationListeners;
    @Autowired(required=false)
    private List<GraphQLServletListener> servletListeners;

    @Bean
    @ConditionalOnProperty(value={"graphql.servlet.corsEnabled"}, havingValue="true", matchIfMissing=true)
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurerAdapter(){

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping(GraphQLWebAutoConfiguration.this.graphQLServletProperties.getMapping());
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutionStrategy executionStrategy() {
        return new SimpleExecutionStrategy();
    }

    @Bean
    ServletRegistrationBean graphQLServletRegistrationBean(GraphQLSchema schema, ExecutionStrategy executionStrategy) {
        return new ServletRegistrationBean((Servlet)new SimpleGraphQLServlet(schema, executionStrategy, this.operationListeners, this.servletListeners), new String[]{this.graphQLServletProperties.getMapping()});
    }
}

