/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.GraphQLSchemaBeanFactory;
import com.oembedler.moon.graphql.SpringGraphQLSchemaBeanFactory;
import com.oembedler.moon.graphql.boot.SpringGraphQLCommonProperties;
import com.oembedler.moon.graphql.engine.GraphQLSchemaBuilder;
import com.oembedler.moon.graphql.engine.GraphQLSchemaConfig;
import com.oembedler.moon.graphql.engine.stereotype.GraphQLSchema;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={SpringGraphQLCommonProperties.class})
public class SpringGraphQLCommonAutoConfiguration {
    @Autowired
    private SpringGraphQLCommonProperties springGraphQLCommonProperties;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaBeanFactory graphQLSchemaBeanFactory() {
        return new SpringGraphQLSchemaBeanFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaConfig graphQLSchemaConfig() {
        GraphQLSchemaConfig graphQLSchemaConfig = new GraphQLSchemaConfig();
        if (this.springGraphQLCommonProperties.getAllowEmptyClientMutationId() != null) {
            graphQLSchemaConfig.setAllowEmptyClientMutationId(this.springGraphQLCommonProperties.getAllowEmptyClientMutationId().booleanValue());
        }
        if (this.springGraphQLCommonProperties.getInjectClientMutationId() != null) {
            graphQLSchemaConfig.setInjectClientMutationId(this.springGraphQLCommonProperties.getInjectClientMutationId().booleanValue());
        }
        if (StringUtils.hasText((String)this.springGraphQLCommonProperties.getClientMutationIdName())) {
            graphQLSchemaConfig.setClientMutationIdName(this.springGraphQLCommonProperties.getClientMutationIdName());
        }
        if (StringUtils.hasText((String)this.springGraphQLCommonProperties.getInputObjectNamePrefix())) {
            graphQLSchemaConfig.setInputObjectNamePrefix(this.springGraphQLCommonProperties.getInputObjectNamePrefix());
        }
        if (StringUtils.hasText((String)this.springGraphQLCommonProperties.getMutationInputArgumentName())) {
            graphQLSchemaConfig.setMutationInputArgumentName(this.springGraphQLCommonProperties.getMutationInputArgumentName());
        }
        if (StringUtils.hasText((String)this.springGraphQLCommonProperties.getOutputObjectNamePrefix())) {
            graphQLSchemaConfig.setOutputObjectNamePrefix(this.springGraphQLCommonProperties.getOutputObjectNamePrefix());
        }
        if (StringUtils.hasText((String)this.springGraphQLCommonProperties.getSchemaMutationObjectName())) {
            graphQLSchemaConfig.setSchemaMutationObjectName(this.springGraphQLCommonProperties.getSchemaMutationObjectName());
        }
        return graphQLSchemaConfig;
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaBuilder graphQLSchemaBuilder() {
        return new GraphQLSchemaBuilder(this.graphQLSchemaConfig(), this.graphQLSchemaBeanFactory());
    }

    @Bean
    @ConditionalOnMissingBean
    public graphql.schema.GraphQLSchema graphQLSchemaLocator() throws ClassNotFoundException {
        Set<Class<?>> schemaClasses = this.findSchemaClasses();
        if (schemaClasses.size() < 1) {
            throw new IllegalStateException("Could not create GraphQLSchema: No valid beans with @GraphQLSchema annotation found!");
        }
        if (schemaClasses.size() > 1) {
            throw new IllegalStateException("Could not create GraphQLSchema: More than one bean with @GraphQLSchema annotation found!  This auto-configuration does not support exposing multiple schemas, please create a graphql.java.GraphQLSchema bean manually or exclude this class from auto-configuration.");
        }
        return this.graphQLSchemaBuilder().buildSchema((Class)schemaClasses.stream().findFirst().orElse(null)).getGraphQLSchema();
    }

    protected Set<Class<?>> findSchemaClasses() {
        Map potentialCandidates = this.applicationContext.getBeansWithAnnotation(GraphQLSchema.class);
        return potentialCandidates.values().stream().map(x -> x.getClass()).collect(Collectors.toSet());
    }
}

