/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.SchemaParser;
import com.coxautodev.graphql.tools.SchemaParserBuilder;
import com.coxautodev.graphql.tools.SchemaParserDictionary;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLSchemaProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
@ConditionalOnClass(value={SchemaParser.class})
public class GraphQLJavaToolsAutoConfiguration {
    @Autowired(required=false)
    private SchemaParserDictionary dictionary;
    @Autowired(required=false)
    private GraphQLScalarType[] scalars;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnBean(value={GraphQLResolver.class})
    @ConditionalOnMissingBean
    public SchemaParser schemaParser(List<GraphQLResolver<?>> resolvers) throws IOException {
        SchemaParserBuilder builder = this.dictionary != null ? new SchemaParserBuilder(this.dictionary) : new SchemaParserBuilder();
        Resource[] resources = this.applicationContext.getResources("classpath*:**/*.graphqls");
        if (resources.length <= 0) {
            throw new IllegalStateException("No *.graphqls files found on classpath.  Please add a graphql schema to the classpath or add a SchemaParser bean to your application context.");
        }
        for (Resource resource : resources) {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)resource.getInputStream(), (Writer)writer);
            builder.schemaString(writer.toString());
        }
        if (this.scalars != null) {
            builder.scalars(this.scalars);
        }
        return builder.resolvers(resolvers).build();
    }

    @Bean
    @ConditionalOnBean(value={SchemaParser.class})
    @ConditionalOnMissingBean(value={GraphQLSchema.class, GraphQLSchemaProvider.class})
    public GraphQLSchema graphQLSchema(SchemaParser schemaParser) {
        return schemaParser.makeExecutableSchema();
    }
}

