/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.PathDetails;
import com.gravity9.jsonpatch.PathParser;
import com.gravity9.jsonpatch.PathValueOperation;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

public final class AddOperation
extends PathValueOperation {
    public static final String LAST_ARRAY_ELEMENT_SYMBOL = "-";

    @JsonCreator
    public AddOperation(@JsonProperty(value="path") String path, @JsonProperty(value="value") JsonNode value) {
        super("add", path, value);
    }

    @Override
    public JsonNode applyInternal(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return this.value;
        }
        PathDetails pathDetails = PathParser.getParentPathAndNewNodeName(this.path);
        String pathToParent = pathDetails.getPathToParent();
        String newNodeName = pathDetails.getNewNodeName();
        DocumentContext nodeContext = JsonPath.parse((Object)node.deepCopy());
        JsonNode evaluatedJsonParents = (JsonNode)nodeContext.read(pathToParent, new Predicate[0]);
        if (!evaluatedJsonParents.isContainerNode()) {
            throw JsonPatchException.parentNotContainer(pathToParent);
        }
        if (pathDetails.doesContainFiltersOrMultiIndexesNotation()) {
            for (int i = 0; i < evaluatedJsonParents.size(); ++i) {
                JsonNode parentNode = evaluatedJsonParents.get(i);
                if (!parentNode.isContainerNode()) {
                    throw JsonPatchException.parentNotContainer(pathToParent + " at index " + i);
                }
                DocumentContext containerContext = JsonPath.parse((Object)parentNode);
                if (parentNode.isArray()) {
                    this.addToArray(containerContext, "$", newNodeName);
                    continue;
                }
                this.addToObject(containerContext, "$", newNodeName);
            }
            return (JsonNode)nodeContext.read("$", new Predicate[0]);
        }
        return evaluatedJsonParents.isArray() ? this.addToArray(nodeContext, pathToParent, newNodeName) : this.addToObject(nodeContext, pathToParent, newNodeName);
    }

    private JsonNode addToArray(DocumentContext node, String jsonPath, String newNodeName) throws JsonPatchException {
        if (newNodeName.equals(LAST_ARRAY_ELEMENT_SYMBOL)) {
            return (JsonNode)node.add(jsonPath, (Object)this.value, new Predicate[0]).read("$", JsonNode.class, new Predicate[0]);
        }
        int size = ((JsonNode)node.read(jsonPath, JsonNode.class, new Predicate[0])).size();
        int index = this.verifyAndGetArrayIndex(newNodeName, size);
        ArrayNode updatedArray = ((ArrayNode)node.read(jsonPath, ArrayNode.class, new Predicate[0])).insert(index, this.value);
        return "$".equals(jsonPath) ? updatedArray : (JsonNode)node.set(jsonPath, (Object)updatedArray, new Predicate[0]).read("$", JsonNode.class, new Predicate[0]);
    }

    private JsonNode addToObject(DocumentContext node, String jsonPath, String newNodeName) {
        return (JsonNode)node.put(jsonPath, newNodeName, (Object)this.value, new Predicate[0]).read("$", JsonNode.class, new Predicate[0]);
    }

    private int verifyAndGetArrayIndex(String stringIndex, int size) throws JsonPatchException {
        int index;
        try {
            index = Integer.parseInt(stringIndex);
        }
        catch (NumberFormatException ignored) {
            throw JsonPatchException.notAnIndex(stringIndex);
        }
        if (index < 0 || index > size) {
            throw JsonPatchException.noSuchIndex(index);
        }
        return index;
    }
}

