/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.gravity9.jsonpatch.AddOperation;
import com.gravity9.jsonpatch.CopyOperation;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.JsonPatchMessages;
import com.gravity9.jsonpatch.MoveOperation;
import com.gravity9.jsonpatch.RemoveOperation;
import com.gravity9.jsonpatch.ReplaceOperation;
import com.gravity9.jsonpatch.TestOperation;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.EnumSet;
import java.util.Set;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="op")
@JsonSubTypes(value={@JsonSubTypes.Type(name="add", value=AddOperation.class), @JsonSubTypes.Type(name="copy", value=CopyOperation.class), @JsonSubTypes.Type(name="move", value=MoveOperation.class), @JsonSubTypes.Type(name="remove", value=RemoveOperation.class), @JsonSubTypes.Type(name="replace", value=ReplaceOperation.class), @JsonSubTypes.Type(name="test", value=TestOperation.class)})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JsonPatchOperation
implements JsonSerializable {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    protected final String op;
    protected final String path;

    protected JsonPatchOperation(String op, String path) {
        this.op = op;
        this.path = path;
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        try {
            return this.applyInternal(node);
        }
        catch (JsonPathException e) {
            throw new JsonPatchException(e.getMessage(), e);
        }
    }

    public abstract JsonNode applyInternal(JsonNode var1) throws JsonPatchException;

    public final String getOp() {
        return this.op;
    }

    public final String getPath() {
        return this.path;
    }

    public abstract String toString();

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){

            public JsonProvider jsonProvider() {
                return new JacksonJsonNodeJsonProvider();
            }

            public Set<Option> options() {
                return EnumSet.of(Option.REQUIRE_PROPERTIES);
            }

            public MappingProvider mappingProvider() {
                return new JacksonMappingProvider();
            }
        });
    }
}

