/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.JsonPathParser;
import com.gravity9.jsonpatch.PathDetails;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.Path;
import com.jayway.jsonpath.internal.path.PathCompiler;
import java.util.ArrayList;
import java.util.List;

public class PathParser {
    private static final String FILTER_PLACEHOLDER = "[?]";

    private PathParser() {
    }

    public static PathDetails getParentPathAndNewNodeName(String path) throws JsonPatchException {
        String fullJsonPath = JsonPathParser.parsePathToJsonPath(path);
        Path compiledPath = PathParser.compilePath(fullJsonPath);
        String[] splitJsonPath = PathParser.splitJsonPath(compiledPath);
        int filterCounter = 0;
        List<String> filters = PathParser.getFiltersOperations(fullJsonPath);
        boolean containsFiltersOrMultiIndexNotation = false;
        StringBuilder sb = new StringBuilder();
        sb.append("$");
        for (int i = 0; i < splitJsonPath.length - 1; ++i) {
            if (splitJsonPath[i].isEmpty()) continue;
            if (splitJsonPath[i].equals(FILTER_PLACEHOLDER)) {
                sb.append(filters.get(filterCounter++));
                containsFiltersOrMultiIndexNotation = true;
                continue;
            }
            if (PathParser.isArrayPart(splitJsonPath[i])) {
                sb.append(splitJsonPath[i]);
                if (!PathParser.isMultiIndexNotation(splitJsonPath[i])) continue;
                containsFiltersOrMultiIndexNotation = true;
                continue;
            }
            if (PathParser.isDoubleDot(splitJsonPath[i])) {
                sb.append(splitJsonPath[i]);
                continue;
            }
            sb.append("[").append(splitJsonPath[i]).append("]");
        }
        String pathToParent = sb.toString();
        String newNodeName = PathParser.getNewNodeName(splitJsonPath);
        return new PathDetails(pathToParent, newNodeName, containsFiltersOrMultiIndexNotation);
    }

    private static boolean isMultiIndexNotation(String path) {
        String pathWithoutBracket = path.replace("[", "").replace("]", "");
        return !pathWithoutBracket.startsWith("'") && !pathWithoutBracket.matches("\\d+");
    }

    private static String getNewNodeName(String[] splitJsonPath) {
        return splitJsonPath[splitJsonPath.length - 1].replace("'", "").replace("[", "").replace("]", "");
    }

    private static String[] splitJsonPath(Path compiledPath) {
        return compiledPath.toString().replace("$", "").split("(?=\\[)");
    }

    private static Path compilePath(String fullJsonPath) throws JsonPatchException {
        try {
            return PathCompiler.compile((String)fullJsonPath, (Predicate[])new Predicate[0]);
        }
        catch (Exception e) {
            throw new JsonPatchException("Non-compilable path provided");
        }
    }

    private static boolean isDoubleDot(String jsonPathPart) {
        return jsonPathPart.equals("..");
    }

    private static boolean isArrayPart(String jsonPathPart) {
        return jsonPathPart.startsWith("[") && jsonPathPart.endsWith("]");
    }

    private static List<String> getFiltersOperations(String jsonPath) {
        if (!jsonPath.contains("[?(")) {
            return new ArrayList<String>();
        }
        ArrayList<String> filters = new ArrayList<String>();
        FilterParserState filterParserState = new FilterParserState();
        for (int i = 0; i < jsonPath.length(); ++i) {
            PathParser.checkIfOpenBracket(jsonPath, i, filterParserState);
            PathParser.checkIfCloseBracket(jsonPath, i, filterParserState, filters);
        }
        return filters;
    }

    private static void checkIfCloseBracket(String jsonPath, int currentPosition, FilterParserState filterParserState, List<String> filters) {
        if (jsonPath.charAt(currentPosition) == ']' && filterParserState.getNumberOfOpenInternalSquareBrackets() > 0) {
            filterParserState.decreaseNumberOfOpenInternalSquareBrackets();
        } else if (jsonPath.charAt(currentPosition) == ']' && filterParserState.getNumberOfOpenedFilters() > 0) {
            filterParserState.decreaseNumberOfOpenedFilters();
            if (filterParserState.noOpenFiltersAndBrackets()) {
                filters.add(jsonPath.substring(filterParserState.getFilterOpeningPosition(), currentPosition + 1));
                filterParserState.setFilterOpeningPosition(-1);
            }
        }
    }

    private static void checkIfOpenBracket(String jsonPath, int currentPosition, FilterParserState filterParserState) {
        if (jsonPath.charAt(currentPosition) == '[' && jsonPath.charAt(currentPosition + 1) == '?') {
            if (!filterParserState.wasOpeningFilterBracketFound()) {
                filterParserState.setFilterOpeningPosition(currentPosition);
            }
            filterParserState.increaseNumberOfOpenedFilters();
        } else if (jsonPath.charAt(currentPosition) == '[') {
            filterParserState.increaseNumberOfOpenInternalSquareBrackets();
        }
    }

    private static class FilterParserState {
        private int filterOpeningPosition = -1;
        private int numberOfOpenedFilters = 0;
        private int numberOfOpenInternalSquareBrackets = 0;

        private FilterParserState() {
        }

        public boolean wasOpeningFilterBracketFound() {
            return this.filterOpeningPosition != -1;
        }

        public void setFilterOpeningPosition(int position) {
            this.filterOpeningPosition = position;
        }

        public void increaseNumberOfOpenedFilters() {
            ++this.numberOfOpenedFilters;
        }

        public void decreaseNumberOfOpenedFilters() {
            --this.numberOfOpenedFilters;
        }

        public void increaseNumberOfOpenInternalSquareBrackets() {
            ++this.numberOfOpenInternalSquareBrackets;
        }

        public void decreaseNumberOfOpenInternalSquareBrackets() {
            --this.numberOfOpenInternalSquareBrackets;
        }

        public int getNumberOfOpenedFilters() {
            return this.numberOfOpenedFilters;
        }

        public int getNumberOfOpenInternalSquareBrackets() {
            return this.numberOfOpenInternalSquareBrackets;
        }

        public int getFilterOpeningPosition() {
            return this.filterOpeningPosition;
        }

        public boolean noOpenFiltersAndBrackets() {
            return this.numberOfOpenedFilters == 0 && this.numberOfOpenInternalSquareBrackets == 0;
        }
    }
}

