/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.JsonPatchOperation;
import com.gravity9.jsonpatch.JsonPathParser;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public final class RemoveOperation
extends JsonPatchOperation {
    @JsonCreator
    public RemoveOperation(@JsonProperty(value="path") String path) {
        super("remove", path);
    }

    @Override
    public JsonNode applyInternal(JsonNode node) throws JsonPatchException {
        if (this.path.isEmpty()) {
            return MissingNode.getInstance();
        }
        DocumentContext nodeContext = JsonPath.parse((Object)node.deepCopy());
        String jsonPath = JsonPathParser.parsePathToJsonPath(this.path);
        return (JsonNode)nodeContext.delete(jsonPath, new Predicate[0]).read("$", JsonNode.class, new Predicate[0]);
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("op", "remove");
        jgen.writeStringField("path", this.path);
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    @Override
    public String toString() {
        return "op: " + this.op + "; path: \"" + this.path + "\"";
    }
}

