/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.JsonPathParser;
import com.gravity9.jsonpatch.PathValueOperation;
import com.gravity9.jsonpatch.jackson.JsonNumEquals;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;

public final class TestOperation
extends PathValueOperation {
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();

    @JsonCreator
    public TestOperation(@JsonProperty(value="path") String path, @JsonProperty(value="value") JsonNode value) {
        super("test", path, value);
    }

    @Override
    public JsonNode applyInternal(JsonNode node) throws JsonPatchException {
        String jsonPath = JsonPathParser.parsePathToJsonPath(this.path);
        JsonNode tested = (JsonNode)JsonPath.parse((Object)node.deepCopy()).read(jsonPath, new Predicate[0]);
        if (!EQUIVALENCE.equivalent(tested, this.value)) {
            throw JsonPatchException.valueTestFailure(this.value, tested);
        }
        return node.deepCopy();
    }
}

