/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.gravity9.jsonpatch.AddOperation;
import com.gravity9.jsonpatch.CopyOperation;
import com.gravity9.jsonpatch.JsonPatchOperation;
import com.gravity9.jsonpatch.MoveOperation;
import com.gravity9.jsonpatch.RemoveOperation;
import com.gravity9.jsonpatch.ReplaceOperation;

final class DiffOperation {
    private final Type type;
    private final JsonPointer from;
    private final JsonNode oldValue;
    private final JsonPointer path;
    private final JsonNode value;

    private DiffOperation(Type type, JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        this.type = type;
        this.from = from;
        this.oldValue = oldValue;
        this.path = path;
        this.value = value;
    }

    static DiffOperation add(JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.ADD, null, null, path, value);
    }

    static DiffOperation copy(JsonPointer from, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.COPY, from, null, path, value);
    }

    static DiffOperation move(JsonPointer from, JsonNode oldValue, JsonPointer path, JsonNode value) {
        return new DiffOperation(Type.MOVE, from, oldValue, path, value);
    }

    static DiffOperation remove(JsonPointer from, JsonNode oldValue) {
        return new DiffOperation(Type.REMOVE, from, oldValue, null, null);
    }

    static DiffOperation replace(JsonPointer from, JsonNode oldValue, JsonNode value) {
        return new DiffOperation(Type.REPLACE, from, oldValue, null, value);
    }

    Type getType() {
        return this.type;
    }

    JsonPointer getFrom() {
        return this.from;
    }

    JsonNode getOldValue() {
        return this.oldValue;
    }

    JsonPointer getPath() {
        return this.path;
    }

    JsonNode getValue() {
        return this.value;
    }

    JsonPatchOperation asJsonPatchOperation() {
        return this.type.toOperation(this);
    }

    static enum Type {
        ADD{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new AddOperation(op.path.toString(), op.value);
            }
        }
        ,
        COPY{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new CopyOperation(op.from.toString(), op.path.toString());
            }
        }
        ,
        MOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new MoveOperation(op.from.toString(), op.path.toString());
            }
        }
        ,
        REMOVE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new RemoveOperation(op.from.toString());
            }
        }
        ,
        REPLACE{

            @Override
            JsonPatchOperation toOperation(DiffOperation op) {
                return new ReplaceOperation(op.from.toString(), op.value);
            }
        };


        abstract JsonPatchOperation toOperation(DiffOperation var1);
    }
}

