/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch.mergepatch;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.mergepatch.JsonMergePatch;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class ObjectMergePatch
extends JsonMergePatch {
    private final Set<String> removedMembers;
    private final Map<String, JsonMergePatch> modifiedMembers;

    ObjectMergePatch(Set<String> removedMembers, Map<String, JsonMergePatch> modifiedMembers) {
        this.removedMembers = Collections.unmodifiableSet(new HashSet<String>(removedMembers));
        this.modifiedMembers = Collections.unmodifiableMap(new HashMap<String, JsonMergePatch>(modifiedMembers));
    }

    @Override
    public JsonNode apply(JsonNode input) throws JsonPatchException {
        BUNDLE.checkNotNull((Object)input, "jsonPatch.nullValue");
        ObjectNode ret = input.isObject() ? (ObjectNode)input.deepCopy() : JacksonUtils.nodeFactory().objectNode();
        for (Map.Entry<String, JsonMergePatch> entry : this.modifiedMembers.entrySet()) {
            String key = entry.getKey();
            JsonNode jsonNode = ret.get(key);
            JsonNode value = jsonNode != null ? jsonNode : NullNode.getInstance();
            ret.replace(key, entry.getValue().apply(value));
        }
        ret.remove(this.removedMembers);
        return ret;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        for (String string : this.removedMembers) {
            jgen.writeNullField(string);
        }
        for (Map.Entry entry : this.modifiedMembers.entrySet()) {
            jgen.writeFieldName((String)entry.getKey());
            ((JsonMergePatch)entry.getValue()).serialize(jgen, provider);
        }
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }
}

