/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch;

import com.gravity9.jsonpatch.JsonPatchException;
import java.util.Arrays;

public class JsonPathParser {
    private static final String ARRAY_ELEMENT_REGEX = "\\A((\\d+)[^a-zA-Z]*)\\z";

    private JsonPathParser() {
    }

    public static String parsePathToJsonPath(String path) throws JsonPatchException {
        if (path.startsWith("$")) {
            return path;
        }
        if (path.contains("?")) {
            throw new JsonPatchException("Invalid path, `?` are not allowed in JsonPointer expressions.");
        }
        if (path.contains("//")) {
            throw new JsonPatchException("Invalid path, `//` is not allowed in JsonPointer expressions.");
        }
        return "$" + Arrays.stream(path.replace('/', '.').replace("~1", "/").replace("~0", "~").split("\\.")).filter(s -> !s.isEmpty()).map(s -> s.replaceAll(ARRAY_ELEMENT_REGEX, "[$1]")).reduce("", (s, s2) -> s + "." + s2);
    }
}

