/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.gravity9.jsonpatch.JsonPatch;
import com.gravity9.jsonpatch.JsonPatchOperation;
import com.gravity9.jsonpatch.diff.DiffOperation;
import com.gravity9.jsonpatch.jackson.JsonNumEquals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class DiffProcessor {
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();
    private final Map<JsonPointer, JsonNode> unchanged;
    private final List<DiffOperation> diffs = new ArrayList<DiffOperation>();

    DiffProcessor(Map<JsonPointer, JsonNode> unchanged) {
        this.unchanged = Collections.unmodifiableMap(new HashMap<JsonPointer, JsonNode>(unchanged));
    }

    void valueReplaced(JsonPointer pointer, JsonNode oldValue, JsonNode newValue) {
        this.diffs.add(DiffOperation.replace(pointer, oldValue, newValue));
    }

    void valueRemoved(JsonPointer pointer, JsonNode value) {
        this.diffs.add(DiffOperation.remove(pointer, value));
    }

    void valueAdded(JsonPointer pointer, JsonNode value) {
        int removalIndex = this.findPreviouslyRemoved(value);
        if (removalIndex != -1) {
            DiffOperation removed = this.diffs.get(removalIndex);
            this.diffs.remove(removalIndex);
            this.diffs.add(DiffOperation.move(removed.getFrom(), value, pointer, value));
            return;
        }
        JsonPointer ptr = this.findUnchangedValue(value);
        DiffOperation op = ptr != null ? DiffOperation.copy(ptr, pointer, value) : DiffOperation.add(pointer, value);
        this.diffs.add(op);
    }

    JsonPatch getPatch() {
        ArrayList<JsonPatchOperation> list = new ArrayList<JsonPatchOperation>();
        for (DiffOperation op : this.diffs) {
            list.add(op.asJsonPatchOperation());
        }
        return new JsonPatch(list);
    }

    @Nullable
    private JsonPointer findUnchangedValue(JsonNode value) {
        for (Map.Entry<JsonPointer, JsonNode> entry : this.unchanged.entrySet()) {
            if (!EQUIVALENCE.equivalent(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private int findPreviouslyRemoved(JsonNode value) {
        for (int i = 0; i < this.diffs.size(); ++i) {
            DiffOperation op = this.diffs.get(i);
            if (op.getType() != DiffOperation.Type.REMOVE || !EQUIVALENCE.equivalent(value, op.getOldValue())) continue;
            return i;
        }
        return -1;
    }
}

