/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.gravity9.jsonpatch.JsonPatch;
import com.gravity9.jsonpatch.JsonPatchException;
import com.gravity9.jsonpatch.JsonPatchMessages;
import com.gravity9.jsonpatch.JsonPatchOperation;
import com.gravity9.jsonpatch.RemoveOperation;
import com.gravity9.jsonpatch.diff.DiffProcessor;
import com.gravity9.jsonpatch.jackson.JsonNumEquals;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class JsonDiff {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonNumEquals EQUIVALENCE = JsonNumEquals.getInstance();
    private static final String NULL_ARGUMENT_KEY = "common.nullArgument";

    private JsonDiff() {
    }

    public static JsonPatch asJsonPatch(JsonNode source, JsonNode target) {
        BUNDLE.checkNotNull((Object)source, NULL_ARGUMENT_KEY);
        BUNDLE.checkNotNull((Object)target, NULL_ARGUMENT_KEY);
        Map<JsonPointer, JsonNode> unchanged = JsonDiff.getUnchangedValues(source, target);
        DiffProcessor processor = new DiffProcessor(unchanged);
        JsonDiff.generateDiffs(processor, JsonPointer.empty(), source, target);
        return processor.getPatch();
    }

    public static JsonPatch asJsonPatchIgnoringFields(JsonNode source, JsonNode target, List<String> fieldsToIgnore) throws JsonPatchException {
        BUNDLE.checkNotNull((Object)source, NULL_ARGUMENT_KEY);
        BUNDLE.checkNotNull((Object)target, NULL_ARGUMENT_KEY);
        List<JsonPatchOperation> ignoredFieldsRemoveOperations = JsonDiff.getJsonPatchRemoveOperationsForIgnoredFields(fieldsToIgnore);
        JsonNode sourceWithoutIgnoredFields = JsonDiff.removeIgnoredFields(source, ignoredFieldsRemoveOperations);
        JsonNode targetWithoutIgnoredFields = JsonDiff.removeIgnoredFields(target, ignoredFieldsRemoveOperations);
        Map<JsonPointer, JsonNode> unchanged = JsonDiff.getUnchangedValues(sourceWithoutIgnoredFields, targetWithoutIgnoredFields);
        DiffProcessor processor = new DiffProcessor(unchanged);
        JsonDiff.generateDiffs(processor, JsonPointer.empty(), sourceWithoutIgnoredFields, targetWithoutIgnoredFields);
        return processor.getPatch();
    }

    private static JsonNode removeIgnoredFields(JsonNode node, List<JsonPatchOperation> ignoredFieldsRemoveOperations) throws JsonPatchException {
        JsonNode nodeWithoutIgnoredFields = node;
        for (JsonPatchOperation operation : ignoredFieldsRemoveOperations) {
            nodeWithoutIgnoredFields = JsonDiff.removeIgnoredFieldOrIgnore(nodeWithoutIgnoredFields, operation);
        }
        return nodeWithoutIgnoredFields;
    }

    private static JsonNode removeIgnoredFieldOrIgnore(JsonNode nodeWithoutIgnoredFields, JsonPatchOperation operation) throws JsonPatchException {
        try {
            ArrayList<JsonPatchOperation> operationsList = new ArrayList<JsonPatchOperation>();
            operationsList.add(operation);
            return new JsonPatch(operationsList).apply(nodeWithoutIgnoredFields);
        }
        catch (JsonPatchException e) {
            if (e.getCause() instanceof PathNotFoundException) {
                return nodeWithoutIgnoredFields;
            }
            throw e;
        }
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) throws JsonPatchException {
        try {
            String s = MAPPER.writeValueAsString((Object)JsonDiff.asJsonPatch(source, target));
            return MAPPER.readTree(s);
        }
        catch (IOException e) {
            throw new JsonPatchException("cannot generate JSON diff", e);
        }
    }

    public static JsonNode asJsonIgnoringFields(JsonNode source, JsonNode target, List<String> fieldsToIgnore) throws JsonPatchException {
        try {
            String s = MAPPER.writeValueAsString((Object)JsonDiff.asJsonPatchIgnoringFields(source, target, fieldsToIgnore));
            return MAPPER.readTree(s);
        }
        catch (IOException e) {
            throw new JsonPatchException("cannot generate JSON diff", e);
        }
    }

    private static void generateDiffs(DiffProcessor processor, JsonPointer pointer, JsonNode source, JsonNode target) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(source, target)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType((JsonNode)source);
        if (firstType != (secondType = NodeType.getNodeType((JsonNode)target))) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (!source.isContainerNode()) {
            processor.valueReplaced(pointer, source, target);
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(processor, pointer, (ObjectNode)source, (ObjectNode)target);
        } else {
            JsonDiff.generateArrayDiffs(processor, pointer, (ArrayNode)source, (ArrayNode)target);
        }
    }

    private static void generateObjectDiffs(DiffProcessor processor, JsonPointer pointer, ObjectNode source, ObjectNode target) {
        Set firstFields = JsonDiff.collect(source.fieldNames(), new TreeSet());
        Set secondFields = JsonDiff.collect(target.fieldNames(), new TreeSet());
        HashSet copy1 = new HashSet(firstFields);
        copy1.removeAll(secondFields);
        for (Object field : Collections.unmodifiableSet(copy1)) {
            processor.valueRemoved(pointer.append((String)field), source.get((String)field));
        }
        HashSet copy2 = new HashSet(secondFields);
        copy2.removeAll(firstFields);
        for (String field : Collections.unmodifiableSet(copy2)) {
            processor.valueAdded(pointer.append(field), target.get(field));
        }
        HashSet intersection = new HashSet(firstFields);
        intersection.retainAll(secondFields);
        for (String field : intersection) {
            JsonDiff.generateDiffs(processor, pointer.append(field), source.get(field), target.get(field));
        }
    }

    private static <T> Set<T> collect(Iterator<T> from, Set<T> to) {
        while (from.hasNext()) {
            to.add(from.next());
        }
        return Collections.unmodifiableSet(to);
    }

    private static void generateArrayDiffs(DiffProcessor processor, JsonPointer pointer, ArrayNode source, ArrayNode target) {
        int size;
        int index;
        int firstSize = source.size();
        int secondSize = target.size();
        for (index = size = Math.min(firstSize, secondSize); index < firstSize; ++index) {
            processor.valueRemoved(pointer.append(size), source.get(index));
        }
        for (index = 0; index < size; ++index) {
            JsonDiff.generateDiffs(processor, pointer.append(index), source.get(index), target.get(index));
        }
        for (index = size; index < secondSize; ++index) {
            processor.valueAdded(pointer.append("-"), target.get(index));
        }
    }

    static Map<JsonPointer, JsonNode> getUnchangedValues(JsonNode source, JsonNode target) {
        HashMap<JsonPointer, JsonNode> ret = new HashMap<JsonPointer, JsonNode>();
        JsonDiff.computeUnchanged(ret, JsonPointer.empty(), source, target);
        return ret;
    }

    private static void computeUnchanged(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode first, JsonNode second) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent(first, second)) {
            ret.put(pointer, second);
            return;
        }
        NodeType firstType = NodeType.getNodeType((JsonNode)first);
        if (firstType != (secondType = NodeType.getNodeType((JsonNode)second))) {
            return;
        }
        switch (firstType) {
            case OBJECT: {
                JsonDiff.computeObject(ret, pointer, first, second);
                break;
            }
            case ARRAY: {
                JsonDiff.computeArray(ret, pointer, first, second);
                break;
            }
        }
    }

    private static void computeObject(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        Iterator firstFields = source.fieldNames();
        while (firstFields.hasNext()) {
            String name = (String)firstFields.next();
            if (!target.has(name)) continue;
            JsonDiff.computeUnchanged(ret, pointer.append(name), source.get(name), target.get(name));
        }
    }

    private static void computeArray(Map<JsonPointer, JsonNode> ret, JsonPointer pointer, JsonNode source, JsonNode target) {
        int size = Math.min(source.size(), target.size());
        for (int i = 0; i < size; ++i) {
            JsonDiff.computeUnchanged(ret, pointer.append(i), source.get(i), target.get(i));
        }
    }

    private static List<JsonPatchOperation> getJsonPatchRemoveOperationsForIgnoredFields(List<String> fieldsToIgnore) {
        ArrayList<JsonPatchOperation> ignoredFieldsRemoveOperations = new ArrayList<JsonPatchOperation>();
        for (String fieldToIgnore : fieldsToIgnore) {
            ignoredFieldsRemoveOperations.add(new RemoveOperation(fieldToIgnore));
        }
        return ignoredFieldsRemoveOperations;
    }
}

