/*
 * Decompiled with CFR 0.152.
 */
package com.gravity9.jsonpatch.mergepatch;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.gravity9.jsonpatch.mergepatch.JsonMergePatch;
import com.gravity9.jsonpatch.mergepatch.NonObjectMergePatch;
import com.gravity9.jsonpatch.mergepatch.ObjectMergePatch;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

final class JsonMergePatchDeserializer
extends JsonDeserializer<JsonMergePatch> {
    JsonMergePatchDeserializer() {
    }

    public JsonMergePatch deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = new ObjectMapper().setConfig(ctxt.getConfig());
        jp.setCodec((ObjectCodec)mapper);
        JsonNode node = (JsonNode)jp.readValueAsTree();
        if (!node.isObject()) {
            return new NonObjectMergePatch(node);
        }
        HashSet<String> removedMembers = new HashSet<String>();
        HashMap<String, JsonMergePatch> modifiedMembers = new HashMap<String, JsonMergePatch>();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((JsonNode)entry.getValue()).isNull()) {
                removedMembers.add((String)entry.getKey());
                continue;
            }
            JsonMergePatch value = this.deserialize(((JsonNode)entry.getValue()).traverse(), ctxt);
            modifiedMembers.put((String)entry.getKey(), value);
        }
        return new ObjectMergePatch(removedMembers, modifiedMembers);
    }

    public JsonMergePatch getNullValue() {
        return new NonObjectMergePatch((JsonNode)NullNode.getInstance());
    }
}

