/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.db;

import com.greedystar.generator.db.DataBaseFactory;
import com.greedystar.generator.entity.ColumnInfo;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.StringUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class ConnectionUtil {
    private Connection connection;

    public boolean initConnection() {
        try {
            Class.forName(DataBaseFactory.getDriver(ConfigUtil.getConfiguration().getDb().getUrl()));
            String url = ConfigUtil.getConfiguration().getDb().getUrl();
            String username = ConfigUtil.getConfiguration().getDb().getUsername();
            String password = ConfigUtil.getConfiguration().getDb().getPassword();
            Properties properties = new Properties();
            properties.put("user", username);
            properties.put("password", password == null ? "" : password);
            properties.setProperty("remarks", "true");
            properties.setProperty("useInformationSchema", "true");
            properties.setProperty("nullCatalogMeansCurrent", "true");
            this.connection = DriverManager.getConnection(url, properties);
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<ColumnInfo> getMetaData(String tableName) throws Exception {
        if (!this.initConnection()) {
            throw new Exception("Failed to connect to database at url:" + ConfigUtil.getConfiguration().getDb().getUrl());
        }
        String primaryKey = this.getPrimaryKey(tableName);
        String tableRemark = this.getTableRemark(tableName);
        List<ColumnInfo> columnInfos = this.getColumnInfos(tableName, primaryKey, tableRemark);
        this.closeConnection();
        return columnInfos;
    }

    private String getPrimaryKey(String tableName) throws SQLException {
        ResultSet keyResultSet = this.connection.getMetaData().getPrimaryKeys(DataBaseFactory.getCatalog(this.connection), DataBaseFactory.getSchema(this.connection), tableName);
        String primaryKey = null;
        if (keyResultSet.next()) {
            primaryKey = keyResultSet.getObject(4).toString();
        }
        keyResultSet.close();
        return primaryKey;
    }

    private String getTableRemark(String tableName) throws SQLException {
        String tableRemark = null;
        if (this.connection.getMetaData().getURL().contains("sqlserver")) {
            tableRemark = this.parseSqlServerTableRemarks(tableName);
        } else {
            ResultSet tableResultSet = this.connection.getMetaData().getTables(DataBaseFactory.getCatalog(this.connection), DataBaseFactory.getSchema(this.connection), tableName, new String[]{"TABLE"});
            if (tableResultSet.next()) {
                tableRemark = StringUtil.isEmpty(tableResultSet.getString("REMARKS")) ? "Unknown Table" : tableResultSet.getString("REMARKS");
            }
            tableResultSet.close();
        }
        return tableRemark;
    }

    private List<ColumnInfo> getColumnInfos(String tableName, String primaryKey, String tableRemark) throws Exception {
        ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
        ResultSet columnResultSet = this.connection.getMetaData().getColumns(DataBaseFactory.getCatalog(this.connection), DataBaseFactory.getSchema(this.connection), tableName, "%");
        while (columnResultSet.next()) {
            boolean isPrimaryKey = columnResultSet.getString("COLUMN_NAME").equals(primaryKey);
            ColumnInfo info = new ColumnInfo(columnResultSet.getString("COLUMN_NAME"), columnResultSet.getInt("DATA_TYPE"), StringUtil.isEmpty(columnResultSet.getString("REMARKS")) ? "Unknown" : columnResultSet.getString("REMARKS"), tableRemark, isPrimaryKey);
            columnInfos.add(info);
        }
        columnResultSet.close();
        if (columnInfos.size() == 0) {
            this.closeConnection();
            throw new Exception("Can not find column information from table:" + tableName);
        }
        if (this.connection.getMetaData().getURL().contains("sqlserver")) {
            this.parseSqlServerColumnRemarks(tableName, columnInfos);
        }
        return columnInfos;
    }

    private String parseSqlServerTableRemarks(String tableName) throws SQLException {
        String tableRemarks = null;
        String sql = "SELECT CAST(ISNULL(p.value, '') AS nvarchar(25)) AS REMARKS FROM sys.tables t LEFT JOIN sys.extended_properties p ON p.major_id=t.object_id AND p.minor_id=0 AND p.class=1 WHERE t.name = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setString(1, tableName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            tableRemarks = StringUtil.isEmpty(resultSet.getString("REMARKS")) ? "Unknown Table" : resultSet.getString("REMARKS");
        }
        resultSet.close();
        preparedStatement.close();
        return tableRemarks;
    }

    private void parseSqlServerColumnRemarks(String tableName, List<ColumnInfo> columnInfos) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT c.name AS COLUMN_NAME, CAST(ISNULL(p.value, '') AS nvarchar(25)) AS REMARKS FROM sys.tables t INNER JOIN sys.columns c ON c.object_id = t.object_id LEFT JOIN sys.extended_properties p ON p.major_id = c.object_id AND p.minor_id = c.column_id WHERE t.name = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        preparedStatement.setString(1, tableName);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            map.put(resultSet.getString("COLUMN_NAME"), StringUtil.isEmpty(resultSet.getString("REMARKS")) ? "Unknown" : resultSet.getString("REMARKS"));
        }
        for (ColumnInfo columnInfo : columnInfos) {
            columnInfo.setRemarks((String)map.get(columnInfo.getColumnName()));
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void closeConnection() throws SQLException {
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
    }
}

