/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.db;

import java.sql.Connection;
import java.sql.SQLException;

public class DataBaseFactory {
    private static final String DRIVER_MYSQL_5 = "com.mysql.jdbc.Driver";
    private static final String DRIVER_MYSQL_UPER = "com.mysql.cj.jdbc.Driver";
    private static final String DRIVER_ORACLE = "oracle.jdbc.driver.OracleDriver";
    private static final String DRIVER_SQLSERVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    public static String getDriver(String url) {
        if (url.contains("mysql")) {
            if (url.contains("serverTimezone")) {
                return DRIVER_MYSQL_UPER;
            }
            return DRIVER_MYSQL_5;
        }
        if (url.contains("oracle")) {
            return DRIVER_ORACLE;
        }
        if (url.contains("sqlserver")) {
            return DRIVER_SQLSERVER;
        }
        return null;
    }

    public static String getCatalog(Connection connection) throws SQLException {
        String url = connection.getMetaData().getURL();
        if (url.contains("mysql")) {
            return null;
        }
        if (url.contains("oracle")) {
            return null;
        }
        if (url.contains("sqlserver")) {
            return url.substring(url.lastIndexOf("=") + 1);
        }
        return null;
    }

    public static String getSchema(Connection connection) throws SQLException {
        String url = connection.getMetaData().getURL();
        if (url.contains("mysql")) {
            if (url.contains("?")) {
                url = url.replace("jdbc:mysql://", "");
                return url.substring(url.indexOf("/") + 1, url.lastIndexOf("?"));
            }
            return url.substring(url.lastIndexOf("/") + 1);
        }
        if (url.contains("oracle")) {
            return connection.getMetaData().getUserName();
        }
        if (url.contains("sqlserver")) {
            return connection.getSchema();
        }
        return null;
    }
}

