/*
 * Decompiled with CFR 0.152.
 */
package com.greedystar.generator.invoker;

import com.greedystar.generator.invoker.base.AbstractBuilder;
import com.greedystar.generator.invoker.base.AbstractInvoker;
import com.greedystar.generator.utils.ConfigUtil;
import com.greedystar.generator.utils.StringUtil;

public class Many2OneInvoker
extends AbstractInvoker {
    private Many2OneInvoker() {
    }

    @Override
    protected void queryMetaData() throws Exception {
        this.tableInfos = this.connectionUtil.getMetaData(this.tableName);
        this.parentTableInfos = this.connectionUtil.getMetaData(this.parentTableName);
    }

    @Override
    protected void initTasks() {
        this.taskQueue.initMany2OneTasks(this);
    }

    public static class Builder
    extends AbstractBuilder {
        public Builder() {
            this.invoker = new Many2OneInvoker();
        }

        public Builder setTableName(String tableName) {
            this.invoker.setTableName(tableName);
            return this;
        }

        public Builder setClassName(String className) {
            this.invoker.setClassName(className);
            return this;
        }

        public Builder setParentTableName(String parentTableName) {
            this.invoker.setParentTableName(parentTableName);
            return this;
        }

        public Builder setParentClassName(String parentClassName) {
            this.invoker.setParentClassName(parentClassName);
            return this;
        }

        public Builder setForeignKey(String foreignKey) {
            this.invoker.setForeignKey(foreignKey);
            return this;
        }

        @Override
        public void checkBeforeBuild() throws Exception {
            if (ConfigUtil.getConfiguration().isMybatisPlusEnable() || ConfigUtil.getConfiguration().isJpaEnable()) {
                throw new Exception("JPA mode and Mybatis-Plus mode only supported in SingleInvoker.");
            }
            if (StringUtil.isEmpty(this.invoker.getTableName())) {
                throw new Exception("Table name can't be null.");
            }
            if (StringUtil.isEmpty(this.invoker.getParentTableName())) {
                throw new Exception("Parent table name can't be null.");
            }
            if (StringUtil.isEmpty(this.invoker.getForeignKey())) {
                throw new Exception("Foreign key can't be null.");
            }
            if (StringUtil.isEmpty(this.invoker.getClassName())) {
                this.invoker.setClassName(StringUtil.tableName2ClassName(this.invoker.getTableName()));
            }
            if (StringUtil.isEmpty(this.invoker.getParentClassName())) {
                this.invoker.setParentClassName(StringUtil.tableName2ClassName(this.invoker.getParentTableName()));
            }
        }
    }
}

